/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.bootstrap.preflight.web.resources;

import jakarta.inject.Inject;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import org.graylog2.audit.jersey.NoAuditEvent;
import org.graylog2.bootstrap.preflight.ConfigurationStatus;
import org.graylog2.bootstrap.preflight.PreflightConfig;
import org.graylog2.bootstrap.preflight.PreflightConfigResult;
import org.graylog2.bootstrap.preflight.PreflightConfigService;
import org.graylog2.plugin.Version;

@Path(value="/api/status")
@Produces(value={"application/json"})
public class PreflightStatusResource {
    private final Version version = Version.CURRENT_CLASSPATH;
    private final PreflightConfigService preflightConfigService;

    @Inject
    public PreflightStatusResource(PreflightConfigService preflightConfigService) {
        this.preflightConfigService = preflightConfigService;
    }

    @GET
    public ConfigurationStatus status() {
        return new ConfigurationStatus(this.version.toString());
    }

    @NoAuditEvent(value="No audit event yet")
    @POST
    @Path(value="/finish-config")
    public PreflightConfig finishConfig() {
        return this.preflightConfigService.setConfigResult(PreflightConfigResult.FINISHED);
    }

    @NoAuditEvent(value="No audit event yet")
    @POST
    @Path(value="/skip-config")
    public PreflightConfig skipConfig() {
        return this.preflightConfigService.setConfigResult(PreflightConfigResult.SKIPPED);
    }
}

