/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.cluster;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.graylog2.shared.utilities.StringUtils;
import org.joda.time.DateTime;

public interface Node {
    public String getNodeId();

    @Deprecated
    @JsonProperty(value="is_master")
    default public boolean isMaster() {
        return this.isLeader();
    }

    public boolean isLeader();

    public String getTransportAddress();

    public DateTime getLastSeen();

    public String getHostname();

    default public String getShortNodeId() {
        return this.getNodeId().split("-")[0];
    }

    @JsonIgnore
    default public String getTitle() {
        return StringUtils.f("%s / %s", this.getShortNodeId(), this.getHostname());
    }
}

