/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.cluster.nodes;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.auto.value.AutoValue;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.graylog.security.certutil.CertRenewalService;
import org.graylog2.cluster.nodes.AutoValue_DataNodeDto;
import org.graylog2.cluster.nodes.DataNodeStatus;
import org.graylog2.cluster.nodes.NodeDto;
import org.graylog2.datanode.DataNodeLifecycleTrigger;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonSerialize(as=DataNodeDto.class)
@JsonDeserialize(builder=Builder.class)
@AutoValue
public abstract class DataNodeDto
extends NodeDto {
    @Nullable
    @JsonProperty(value="cluster_address")
    public abstract String getClusterAddress();

    @Nullable
    @JsonProperty(value="rest_api_address")
    public abstract String getRestApiAddress();

    @JsonProperty(value="data_node_status")
    public abstract DataNodeStatus getDataNodeStatus();

    @Nullable
    @JsonProperty(value="action_queue")
    public abstract DataNodeLifecycleTrigger getActionQueue();

    @Nullable
    @JsonUnwrapped
    public abstract CertRenewalService.ProvisioningInformation getProvisioningInformation();

    @Override
    public Map<String, Object> toEntityParameters() {
        Map<String, Object> params = super.toEntityParameters();
        if (Objects.nonNull(this.getClusterAddress())) {
            params.put("cluster_address", this.getClusterAddress());
        }
        if (Objects.nonNull(this.getRestApiAddress())) {
            params.put("rest_api_address", this.getRestApiAddress());
        }
        if (Objects.nonNull((Object)this.getDataNodeStatus())) {
            params.put("datanode_status", (Object)this.getDataNodeStatus());
        }
        if (Objects.nonNull((Object)this.getActionQueue())) {
            if (this.getActionQueue() == DataNodeLifecycleTrigger.CLEAR) {
                params.put("action_queue", null);
            } else {
                params.put("action_queue", (Object)this.getActionQueue());
            }
        }
        return params;
    }

    public abstract Builder toBuilder();

    @JsonIgnoreProperties(ignoreUnknown=true)
    @AutoValue.Builder
    public static abstract class Builder
    extends NodeDto.Builder<Builder> {
        @JsonCreator
        public static Builder builder() {
            return new AutoValue_DataNodeDto.Builder();
        }

        @JsonProperty(value="cluster_address")
        public abstract Builder setClusterAddress(String var1);

        @JsonProperty(value="rest_api_address")
        public abstract Builder setRestApiAddress(String var1);

        @JsonProperty(value="datanode_status")
        public abstract Builder setDataNodeStatus(DataNodeStatus var1);

        @JsonProperty(value="action_queue")
        public abstract Builder setActionQueue(DataNodeLifecycleTrigger var1);

        public abstract Builder setProvisioningInformation(CertRenewalService.ProvisioningInformation var1);

        public abstract DataNodeDto build();
    }
}

