/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.database.filtering.inmemory;

import com.google.common.base.Predicates;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.graylog2.database.filtering.Filter;
import org.graylog2.database.filtering.inmemory.InMemoryFilterable;
import org.graylog2.database.filtering.inmemory.SingleFilterParser;
import org.graylog2.rest.resources.entities.EntityAttribute;

public class InMemoryFilterExpressionParser {
    private final SingleFilterParser singleFilterParser = new SingleFilterParser();

    public Predicate<InMemoryFilterable> parse(List<String> filterExpressions, List<EntityAttribute> attributes) {
        if (filterExpressions == null || filterExpressions.isEmpty()) {
            return Predicates.alwaysTrue();
        }
        Map<String, List<Filter>> groupedByField = filterExpressions.stream().map(expr -> this.singleFilterParser.parseSingleExpression((String)expr, attributes)).collect(Collectors.groupingBy(Filter::field));
        return groupedByField.values().stream().map(grouped -> grouped.stream().map(Filter::toPredicate).collect(Collectors.toList())).map(groupedPredicates -> (Predicate)groupedPredicates.stream().reduce(Predicate::or).orElse(Predicates.alwaysTrue())).reduce(Predicate::and).orElse((Predicate)Predicates.alwaysTrue());
    }
}

