/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.indexer.rotation;

import java.util.Iterator;
import org.graylog2.configuration.ElasticsearchConfiguration;
import org.graylog2.indexer.rotation.strategies.MessageCountRotationStrategy;
import org.graylog2.indexer.rotation.strategies.SizeBasedRotationStrategy;
import org.graylog2.indexer.rotation.strategies.TimeBasedRotationStrategy;
import org.graylog2.indexer.rotation.strategies.TimeBasedSizeOptimizingStrategy;
import org.graylog2.plugin.PluginModule;

public class RotationStrategyBindings
extends PluginModule {
    private final ElasticsearchConfiguration elasticsearchConfiguration;

    public RotationStrategyBindings(ElasticsearchConfiguration elasticsearchConfiguration) {
        this.elasticsearchConfiguration = elasticsearchConfiguration;
    }

    protected void configure() {
        Iterator<String> iterator = this.elasticsearchConfiguration.getEnabledRotationStrategies().iterator();
        while (iterator.hasNext()) {
            String strategy;
            switch (strategy = iterator.next()) {
                case "count": {
                    this.addRotationStrategy(MessageCountRotationStrategy.class);
                    break;
                }
                case "size": {
                    this.addRotationStrategy(SizeBasedRotationStrategy.class);
                    break;
                }
                case "time": {
                    this.addRotationStrategy(TimeBasedRotationStrategy.class);
                    break;
                }
                case "time-size-optimizing": {
                    this.addRotationStrategy(TimeBasedSizeOptimizingStrategy.class);
                }
            }
        }
    }
}

