/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.indexer.rotation.strategies;

import jakarta.inject.Inject;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.Optional;
import javax.annotation.Nullable;
import org.graylog2.indexer.IndexSet;
import org.graylog2.indexer.indices.Indices;
import org.graylog2.indexer.rotation.common.IndexRotator;
import org.graylog2.indexer.rotation.strategies.SizeBasedRotationStrategyConfig;
import org.graylog2.plugin.indexer.rotation.RotationStrategy;
import org.graylog2.plugin.indexer.rotation.RotationStrategyConfig;

public class SizeBasedRotationStrategy
implements RotationStrategy {
    public static final String NAME = "size";
    private final Indices indices;
    private final IndexRotator indexRotator;

    @Inject
    public SizeBasedRotationStrategy(Indices indices, IndexRotator indexRotator) {
        this.indices = indices;
        this.indexRotator = indexRotator;
    }

    @Override
    public void rotate(IndexSet indexSet) {
        this.indexRotator.rotate(indexSet, this::shouldRotate);
    }

    @Override
    public Class<? extends RotationStrategyConfig> configurationClass() {
        return SizeBasedRotationStrategyConfig.class;
    }

    @Override
    public RotationStrategyConfig defaultConfiguration() {
        return SizeBasedRotationStrategyConfig.createDefault();
    }

    @Nullable
    private IndexRotator.Result shouldRotate(String index, IndexSet indexSet) {
        if (!(indexSet.getConfig().rotationStrategy() instanceof SizeBasedRotationStrategyConfig)) {
            throw new IllegalStateException("Invalid rotation strategy config <" + indexSet.getConfig().rotationStrategy().getClass().getCanonicalName() + "> for index set <" + indexSet.getConfig().id() + ">");
        }
        SizeBasedRotationStrategyConfig config = (SizeBasedRotationStrategyConfig)indexSet.getConfig().rotationStrategy();
        Optional<Long> storeSizeInBytes = this.indices.getStoreSizeInBytes(index);
        if (!storeSizeInBytes.isPresent()) {
            return null;
        }
        long sizeInBytes = storeSizeInBytes.get();
        boolean shouldRotate = sizeInBytes > config.maxSize();
        MessageFormat format = shouldRotate ? new MessageFormat("Storage size for index <{0}> is {1} bytes, exceeding the maximum of {2} bytes. Rotating index.", Locale.ENGLISH) : new MessageFormat("Storage size for index <{0}> is {1} bytes, below the maximum of {2} bytes. Not doing anything.", Locale.ENGLISH);
        String message = format.format(new Object[]{index, sizeInBytes, config.maxSize()});
        return IndexRotator.createResult(shouldRotate, message, this.getClass().getCanonicalName());
    }

    @Override
    public String getStrategyName() {
        return NAME;
    }
}

