/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.inputs.extractors;

import com.codahale.metrics.MetricRegistry;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.graylog2.ConfigurationException;
import org.graylog2.plugin.inputs.Converter;
import org.graylog2.plugin.inputs.Extractor;

public class RegexExtractor
extends Extractor {
    private static final String CONFIG_REGEX_VALUE = "regex_value".intern();
    private final Pattern pattern;

    public RegexExtractor(MetricRegistry metricRegistry, String id, String title, long order, Extractor.CursorStrategy cursorStrategy, String sourceField, String targetField, Map<String, Object> extractorConfig, String creatorUserId, List<Converter> converters, Extractor.ConditionType conditionType, String conditionValue) throws Extractor.ReservedFieldException, ConfigurationException {
        super(metricRegistry, id, title, order, Extractor.Type.REGEX, cursorStrategy, sourceField, targetField, extractorConfig, creatorUserId, converters, conditionType, conditionValue);
        if (extractorConfig == null || extractorConfig.get(CONFIG_REGEX_VALUE) == null || ((String)extractorConfig.get(CONFIG_REGEX_VALUE)).isEmpty()) {
            throw new ConfigurationException("Missing regex configuration field: regex_value");
        }
        this.pattern = Pattern.compile((String)extractorConfig.get(CONFIG_REGEX_VALUE), 32);
    }

    @Override
    protected Extractor.Result[] run(String value) {
        Matcher matcher = this.pattern.matcher(value);
        if (!matcher.find() || matcher.groupCount() == 0 || matcher.start(1) == -1 || matcher.end(1) == -1) {
            return null;
        }
        return new Extractor.Result[]{new Extractor.Result(value.substring(matcher.start(1), matcher.end(1)), matcher.start(1), matcher.end(1))};
    }
}

