/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.rest.resources.system.field_types;

import com.codahale.metrics.annotation.Timed;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import jakarta.inject.Inject;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.graylog2.audit.jersey.AuditEvent;
import org.graylog2.indexer.fieldtypes.IndexFieldTypesListService;
import org.graylog2.indexer.fieldtypes.mapping.FieldTypeMappingsService;
import org.graylog2.indexer.indexset.CustomFieldMapping;
import org.graylog2.indexer.indexset.CustomFieldMappings;
import org.graylog2.rest.bulk.model.BulkOperationFailure;
import org.graylog2.rest.bulk.model.BulkOperationResponse;
import org.graylog2.rest.resources.system.field_types.CustomFieldMappingRemovalRequest;
import org.graylog2.rest.resources.system.field_types.FieldTypeChangeRequest;
import org.graylog2.rest.resources.system.field_types.FieldTypeProfileChangeRequest;
import org.graylog2.rest.resources.system.field_types.FieldTypeProfileUnsetRequest;
import org.graylog2.rest.resources.system.indexer.responses.IndexSetFieldType;
import org.graylog2.shared.rest.resources.RestResource;

@RequiresAuthentication
@Api(value="System/FieldTypes", tags={"cloud"})
@Path(value="/system/indices/mappings")
@Produces(value={"application/json"})
public class FieldTypeMappingsResource
extends RestResource {
    private final FieldTypeMappingsService fieldTypeMappingsService;
    private final IndexFieldTypesListService indexFieldTypesListService;

    @Inject
    public FieldTypeMappingsResource(FieldTypeMappingsService fieldTypeMappingsService, IndexFieldTypesListService indexFieldTypesListService) {
        this.fieldTypeMappingsService = fieldTypeMappingsService;
        this.indexFieldTypesListService = indexFieldTypesListService;
    }

    @GET
    @Path(value="/types")
    @Timed
    @ApiOperation(value="Get list of all types valid inside the indexer")
    public Map<String, String> getAllFieldTypes() {
        return CustomFieldMappings.AVAILABLE_TYPES.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((CustomFieldMappings.TypeDescription)entry.getValue()).description()));
    }

    @PUT
    @Timed
    @ApiOperation(value="Change field type for certain index sets")
    @ApiResponses(value={@ApiResponse(code=403, message="Unauthorized")})
    @AuditEvent(type="server:field_type_mapping:create")
    public Map<String, IndexSetFieldType> changeFieldType(@ApiParam(name="request") @Valid @NotNull(message="Request body is mandatory") @Valid @NotNull(message="Request body is mandatory") FieldTypeChangeRequest request) {
        this.checkPermissions(request.indexSetsIds(), "typemappings:create");
        CustomFieldMapping customMapping = new CustomFieldMapping(request.fieldName(), request.type());
        this.fieldTypeMappingsService.changeFieldType(customMapping, request.indexSetsIds(), request.rotateImmediately());
        return this.newFieldTypes(request.indexSetsIds(), request.fieldName());
    }

    private Map<String, IndexSetFieldType> newFieldTypes(Set<String> indexSetIds, String fieldName) {
        Map<String, List<IndexSetFieldType>> newIndexFieldTypes = this.indexFieldTypesListService.getIndexSetFieldTypesList(indexSetIds, Set.of(fieldName));
        return newIndexFieldTypes.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((List)entry.getValue()).stream().filter(fieldType -> fieldType.fieldName().equals(fieldName)).findFirst().orElseThrow(() -> new RuntimeException("Missing entry in field types list."))));
    }

    @PUT
    @Path(value="/set_profile")
    @Timed
    @ApiOperation(value="Set field type profile for certain index sets")
    @ApiResponses(value={@ApiResponse(code=403, message="Unauthorized")})
    @AuditEvent(type="server:index_set:update")
    public Response setProfile(@ApiParam(name="request") @Valid @NotNull(message="Request body is mandatory") @Valid @NotNull(message="Request body is mandatory") FieldTypeProfileChangeRequest request) {
        this.checkPermissions(request.indexSetsIds(), "indexsets:edit");
        this.fieldTypeMappingsService.setProfile(request.indexSetsIds(), request.profileId(), request.rotateImmediately());
        return Response.ok().build();
    }

    @PUT
    @Path(value="/remove_profile_from")
    @Timed
    @ApiOperation(value="Remove field type profile from certain index sets")
    @ApiResponses(value={@ApiResponse(code=403, message="Unauthorized")})
    @AuditEvent(type="server:index_set:update")
    public Response removeProfileFromIndexSets(@ApiParam(name="request") @Valid @NotNull(message="Request body is mandatory") @Valid @NotNull(message="Request body is mandatory") FieldTypeProfileUnsetRequest request) {
        this.checkPermissions(request.indexSetsIds(), "indexsets:edit");
        this.fieldTypeMappingsService.removeProfileFromIndexSets(request.indexSetsIds(), request.rotateImmediately());
        return Response.ok().build();
    }

    @PUT
    @Path(value="/remove_mapping")
    @Timed
    @ApiOperation(value="Remove custom field mapping for certain index sets")
    @ApiResponses(value={@ApiResponse(code=403, message="Unauthorized")})
    @AuditEvent(type="server:field_type_mapping:delete")
    public Map<String, MappingRemovalResult> removeCustomMapping(@ApiParam(name="request") @Valid @NotNull(message="Request body is mandatory") @Valid @NotNull(message="Request body is mandatory") CustomFieldMappingRemovalRequest request) {
        this.checkPermissions(request.indexSetsIds(), "typemappings:delete");
        Map<String, BulkOperationResponse> result = this.fieldTypeMappingsService.removeCustomMappingForFields(request.fieldNames(), request.indexSetsIds(), request.rotateImmediately());
        Map<String, List<IndexSetFieldType>> newTypes = this.indexFieldTypesListService.getIndexSetFieldTypesList(request.indexSetsIds(), request.fieldNames());
        return result.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, value -> new MappingRemovalResult(((BulkOperationResponse)value.getValue()).successfullyPerformed(), ((BulkOperationResponse)value.getValue()).failures(), ((BulkOperationResponse)value.getValue()).errors(), (List)newTypes.get(value.getKey()))));
    }

    private void checkPermissions(Set<String> indexSetsIds, String permission) {
        indexSetsIds.forEach(indexSetId -> this.checkPermission(permission, (String)indexSetId));
    }

    public record MappingRemovalResult(@JsonProperty(value="successfully_performed") int successfullyPerformed, @JsonProperty(value="failures") List<BulkOperationFailure> failures, @JsonProperty(value="errors") List<String> errors, @JsonProperty(value="succeeded") List<IndexSetFieldType> succeeded) {
    }
}

