/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.rest.resources.system.inputs;

import com.codahale.metrics.Counter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import com.codahale.metrics.annotation.Timed;
import com.eaio.uuid.UUID;
import com.google.common.collect.Lists;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import jakarta.inject.Inject;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.graylog2.ConfigurationException;
import org.graylog2.audit.jersey.AuditEvent;
import org.graylog2.inputs.Input;
import org.graylog2.inputs.InputService;
import org.graylog2.inputs.converters.ConverterFactory;
import org.graylog2.inputs.extractors.ExtractorFactory;
import org.graylog2.plugin.Tools;
import org.graylog2.plugin.database.ValidationException;
import org.graylog2.plugin.inputs.Converter;
import org.graylog2.plugin.inputs.Extractor;
import org.graylog2.plugin.inputs.MessageInput;
import org.graylog2.rest.models.system.inputs.extractors.requests.CreateExtractorRequest;
import org.graylog2.rest.models.system.inputs.extractors.requests.OrderExtractorsRequest;
import org.graylog2.rest.models.system.inputs.extractors.responses.ExtractorCreated;
import org.graylog2.rest.models.system.inputs.extractors.responses.ExtractorMetrics;
import org.graylog2.rest.models.system.inputs.extractors.responses.ExtractorSummary;
import org.graylog2.rest.models.system.inputs.extractors.responses.ExtractorSummaryList;
import org.graylog2.rest.resources.system.inputs.InputsResource;
import org.graylog2.shared.inputs.PersistedInputs;
import org.graylog2.shared.metrics.MetricUtils;
import org.graylog2.shared.rest.resources.RestResource;
import org.graylog2.shared.system.activities.Activity;
import org.graylog2.shared.system.activities.ActivityWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RequiresAuthentication
@Api(value="Extractors", description="Extractors of an input")
@Path(value="/system/inputs/{inputId}/extractors")
public class ExtractorsResource
extends RestResource {
    private static final Logger LOG = LoggerFactory.getLogger(ExtractorsResource.class);
    private final InputService inputService;
    private final ActivityWriter activityWriter;
    private final MetricRegistry metricRegistry;
    private final ExtractorFactory extractorFactory;
    private final ConverterFactory converterFactory;
    private final PersistedInputs persistedInputs;

    @Inject
    public ExtractorsResource(InputService inputService, ActivityWriter activityWriter, MetricRegistry metricRegistry, ExtractorFactory extractorFactory, ConverterFactory converterFactory, PersistedInputs persistedInputs) {
        this.inputService = inputService;
        this.activityWriter = activityWriter;
        this.metricRegistry = metricRegistry;
        this.extractorFactory = extractorFactory;
        this.converterFactory = converterFactory;
        this.persistedInputs = persistedInputs;
    }

    @POST
    @Timed
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Add an extractor to an input", response=ExtractorCreated.class)
    @ApiResponses(value={@ApiResponse(code=404, message="No such input on this node."), @ApiResponse(code=400, message="No such extractor type."), @ApiResponse(code=400, message="Field the extractor should write on is reserved."), @ApiResponse(code=400, message="Missing or invalid configuration.")})
    @AuditEvent(type="server:extractor:create")
    public Response create(@ApiParam(name="inputId", required=true) @PathParam(value="inputId") String inputId, @ApiParam(name="JSON body", required=true) @Valid @NotNull CreateExtractorRequest cer) throws org.graylog2.database.NotFoundException {
        this.checkPermission("inputs:edit", inputId);
        Input mongoInput = this.inputService.find(inputId);
        String id = new UUID().toString();
        Extractor extractor = this.buildExtractorFromRequest(cer, id);
        try {
            this.inputService.addExtractor(mongoInput, extractor);
        }
        catch (ValidationException e) {
            String msg = "Extractor persist validation failed.";
            LOG.error("Extractor persist validation failed.", (Throwable)e);
            throw new BadRequestException("Extractor persist validation failed.", (Throwable)e);
        }
        String msg = "Added extractor <" + id + "> of type [" + cer.extractorType() + "] to input <" + inputId + ">.";
        LOG.info(msg);
        this.activityWriter.write(new Activity(msg, ExtractorsResource.class));
        ExtractorCreated result = ExtractorCreated.create(id);
        URI extractorUri = this.getUriBuilderToSelf().path(ExtractorsResource.class).path("{inputId}").build(new Object[]{mongoInput.getId()});
        return Response.created((URI)extractorUri).entity((Object)result).build();
    }

    @PUT
    @Timed
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Update an extractor")
    @Path(value="/{extractorId}")
    @ApiResponses(value={@ApiResponse(code=404, message="No such input on this node."), @ApiResponse(code=404, message="No such extractor on this input."), @ApiResponse(code=400, message="No such extractor type."), @ApiResponse(code=400, message="Field the extractor should write on is reserved."), @ApiResponse(code=400, message="Missing or invalid configuration.")})
    @AuditEvent(type="server:extractor:update")
    public ExtractorSummary update(@ApiParam(name="inputId", required=true) @PathParam(value="inputId") String inputId, @ApiParam(name="extractorId", required=true) @PathParam(value="extractorId") String extractorId, @ApiParam(name="JSON body", required=true) @Valid @NotNull CreateExtractorRequest cer) throws org.graylog2.database.NotFoundException {
        this.checkPermission("inputs:edit", inputId);
        Input mongoInput = this.inputService.find(inputId);
        Extractor originalExtractor = this.inputService.getExtractor(mongoInput, extractorId);
        Extractor extractor = this.buildExtractorFromRequest(cer, originalExtractor.getId());
        try {
            this.inputService.updateExtractor(mongoInput, extractor);
        }
        catch (ValidationException e) {
            LOG.error("Extractor persist validation failed.", (Throwable)e);
            throw new BadRequestException((Throwable)e);
        }
        String msg = "Updated extractor <" + originalExtractor.getId() + "> of type [" + cer.extractorType() + "] in input <" + inputId + ">.";
        LOG.info(msg);
        this.activityWriter.write(new Activity(msg, ExtractorsResource.class));
        return this.toSummary(extractor);
    }

    @GET
    @Timed
    @ApiOperation(value="List all extractors of an input")
    @ApiResponses(value={@ApiResponse(code=404, message="No such input on this node.")})
    @Produces(value={"application/json"})
    public ExtractorSummaryList list(@ApiParam(name="inputId", required=true) @PathParam(value="inputId") String inputId) throws org.graylog2.database.NotFoundException {
        this.checkPermission("inputs:read", inputId);
        Input input = this.inputService.find(inputId);
        ArrayList extractors = Lists.newArrayList();
        for (Extractor extractor : this.inputService.getExtractors(input)) {
            extractors.add(this.toSummary(extractor));
        }
        return ExtractorSummaryList.create(extractors);
    }

    @GET
    @Timed
    @ApiOperation(value="Get information of a single extractor of an input")
    @Path(value="/{extractorId}")
    @ApiResponses(value={@ApiResponse(code=404, message="No such input on this node."), @ApiResponse(code=404, message="No such extractor on this input.")})
    @Produces(value={"application/json"})
    public ExtractorSummary single(@ApiParam(name="inputId", required=true) @PathParam(value="inputId") String inputId, @ApiParam(name="extractorId", required=true) @PathParam(value="extractorId") String extractorId) throws org.graylog2.database.NotFoundException {
        this.checkPermission("inputs:read", inputId);
        MessageInput input = this.persistedInputs.get(inputId);
        if (input == null) {
            LOG.error("Input <{}> not found.", (Object)inputId);
            throw new NotFoundException("Couldn't find input " + inputId);
        }
        Input mongoInput = this.inputService.find(input.getPersistId());
        Extractor extractor = this.inputService.getExtractor(mongoInput, extractorId);
        return this.toSummary(extractor);
    }

    @DELETE
    @Timed
    @ApiOperation(value="Delete an extractor")
    @Path(value="/{extractorId}")
    @ApiResponses(value={@ApiResponse(code=400, message="Invalid request."), @ApiResponse(code=404, message="Input not found."), @ApiResponse(code=404, message="Extractor not found.")})
    @Produces(value={"application/json"})
    @AuditEvent(type="server:extractor:delete")
    public void terminate(@ApiParam(name="inputId", required=true) @PathParam(value="inputId") String inputId, @ApiParam(name="extractorId", required=true) @PathParam(value="extractorId") String extractorId) throws org.graylog2.database.NotFoundException {
        this.checkPermission("inputs:edit", inputId);
        MessageInput input = this.persistedInputs.get(inputId);
        if (input == null) {
            LOG.error("Input <{}> not found.", (Object)inputId);
            throw new NotFoundException("Couldn't find input " + inputId);
        }
        Input mongoInput = this.inputService.find(input.getPersistId());
        Extractor extractor = this.inputService.getExtractor(mongoInput, extractorId);
        this.inputService.removeExtractor(mongoInput, extractor.getId());
        String msg = "Deleted extractor <" + extractorId + "> of type [" + extractor.getType() + "] from input <" + inputId + ">.";
        LOG.info(msg);
        this.activityWriter.write(new Activity(msg, InputsResource.class));
    }

    @POST
    @Timed
    @Consumes(value={"application/json"})
    @ApiOperation(value="Update extractor order of an input")
    @ApiResponses(value={@ApiResponse(code=404, message="No such input on this node.")})
    @Path(value="order")
    @AuditEvent(type="server:extractor_order:update")
    public void order(@ApiParam(name="inputId", value="Persist ID (!) of input.", required=true) @PathParam(value="inputId") String inputPersistId, @ApiParam(name="JSON body", required=true) OrderExtractorsRequest oer) throws org.graylog2.database.NotFoundException {
        this.checkPermission("inputs:edit", inputPersistId);
        Input mongoInput = this.inputService.find(inputPersistId);
        for (Extractor extractor : this.inputService.getExtractors(mongoInput)) {
            if (oer.order().containsValue(extractor.getId())) {
                extractor.setOrder(Tools.getKeyByValue(oer.order(), extractor.getId()).intValue());
            }
            this.inputService.removeExtractor(mongoInput, extractor.getId());
            try {
                this.inputService.addExtractor(mongoInput, extractor);
            }
            catch (ValidationException e) {
                LOG.warn("Validation error for extractor update.", (Throwable)e);
            }
        }
        LOG.info("Updated extractor ordering of input <persist:{}>.", (Object)inputPersistId);
    }

    private ExtractorSummary toSummary(Extractor extractor) {
        ExtractorMetrics metrics = ExtractorMetrics.create(MetricUtils.buildTimerMap((Timer)this.metricRegistry.getTimers().get(extractor.getCompleteTimerName())), MetricUtils.buildTimerMap((Timer)this.metricRegistry.getTimers().get(extractor.getConditionTimerName())), MetricUtils.buildTimerMap((Timer)this.metricRegistry.getTimers().get(extractor.getExecutionTimerName())), MetricUtils.buildTimerMap((Timer)this.metricRegistry.getTimers().get(extractor.getConverterTimerName())), ((Counter)this.metricRegistry.getCounters().get(extractor.getConditionHitsCounterName())).getCount(), ((Counter)this.metricRegistry.getCounters().get(extractor.getConditionMissesCounterName())).getCount());
        return ExtractorSummary.create(extractor.getId(), extractor.getTitle(), extractor.getType().toString().toLowerCase(Locale.ENGLISH), extractor.getCursorStrategy().toString().toLowerCase(Locale.ENGLISH), extractor.getSourceField(), extractor.getTargetField(), extractor.getExtractorConfig(), extractor.getCreatorUserId(), extractor.converterConfigMap(), extractor.getConditionType().toString().toLowerCase(Locale.ENGLISH), extractor.getConditionValue(), extractor.getOrder(), extractor.getExceptionCount(), extractor.getConverterExceptionCount(), metrics);
    }

    private List<Converter> loadConverters(List<Map<String, Object>> list) {
        ArrayList converters = Lists.newArrayList();
        for (Map<String, Object> map : list) {
            try {
                String type = map.get("type").toString().toUpperCase(Locale.ENGLISH);
                Map config = (Map)map.get("config");
                converters.add(this.converterFactory.create(Converter.Type.valueOf(type), config));
            }
            catch (ConverterFactory.NoSuchConverterException e) {
                LOG.warn("No such converter [" + map.get("type") + "]. Skipping.", (Throwable)e);
            }
            catch (ConfigurationException e) {
                LOG.warn("Missing configuration for [" + map.get("type") + "]. Skipping.", (Throwable)e);
            }
        }
        return converters;
    }

    private Extractor buildExtractorFromRequest(CreateExtractorRequest cer, String id) {
        Extractor extractor;
        try {
            extractor = this.extractorFactory.factory(id, cer.title(), cer.order(), Extractor.CursorStrategy.valueOf(cer.cursorStrategy().toUpperCase(Locale.ENGLISH)), Extractor.Type.valueOf(cer.extractorType().toUpperCase(Locale.ENGLISH)), cer.sourceField(), cer.targetField(), cer.extractorConfig(), this.getCurrentUser().getName(), this.loadConverters(cer.converters()), Extractor.ConditionType.valueOf(cer.conditionType().toUpperCase(Locale.ENGLISH)), cer.conditionValue());
        }
        catch (ExtractorFactory.NoSuchExtractorException e) {
            LOG.error("No such extractor type.", (Throwable)e);
            throw new BadRequestException((Throwable)e);
        }
        catch (Extractor.ReservedFieldException e) {
            LOG.error("Cannot create extractor. Field is reserved.", (Throwable)e);
            throw new BadRequestException((Throwable)e);
        }
        catch (ConfigurationException e) {
            LOG.error("Cannot create extractor. Missing configuration.", (Throwable)e);
            throw new BadRequestException((Throwable)e);
        }
        return extractor;
    }
}

