/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.rest.resources.tools;

import com.codahale.metrics.annotation.Timed;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.auto.value.AutoValue;
import jakarta.validation.constraints.NotEmpty;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.WebApplicationException;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.graylog2.plugin.utilities.date.NaturalDateParser;
import org.graylog2.rest.resources.tools.AutoValue_NaturalDateTesterResource_NaturalDateResponse;
import org.graylog2.rest.resources.tools.RegexTesterResource;
import org.graylog2.shared.rest.resources.RestResource;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RequiresAuthentication
@Path(value="/tools/natural_date_tester")
public class NaturalDateTesterResource
extends RestResource {
    private static final Logger LOG = LoggerFactory.getLogger(RegexTesterResource.class);

    @GET
    @Timed
    @Produces(value={"application/json"})
    public NaturalDateResponse naturalDateTester(@QueryParam(value="string") @NotEmpty String string, @QueryParam(value="timezone") @NotEmpty String timezone) {
        try {
            NaturalDateParser.Result result = new NaturalDateParser(timezone).parse(string);
            return NaturalDateResponse.create(result);
        }
        catch (NaturalDateParser.DateNotParsableException e) {
            LOG.debug("Could not parse from natural date: " + string + " and TimeZone: " + timezone, (Throwable)e);
            throw new WebApplicationException((Throwable)e, 422);
        }
    }

    @AutoValue
    public static abstract class NaturalDateResponse {
        @JsonProperty
        public abstract DateTime from();

        @JsonProperty
        public abstract DateTime to();

        @JsonProperty
        public abstract String timezone();

        static NaturalDateResponse create(NaturalDateParser.Result result) {
            return new AutoValue_NaturalDateTesterResource_NaturalDateResponse(result.getFrom(), result.getTo(), result.getDateTimeZone().getID());
        }
    }
}

