/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.security;

import com.google.common.base.Preconditions;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.SecureRandom;
import java.util.Arrays;
import javax.annotation.Nullable;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Hex;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.paddings.ISO10126d2Padding;
import org.cryptomator.siv.SivMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AESTools {
    private static final Logger LOG = LoggerFactory.getLogger(AESTools.class);
    private static final SivMode SIV_MODE = new SivMode();
    private static final String CIPHER_TRANSFORMATION = "AES/CBC/PKCS5Padding";
    private static final String CIPHER_NO_PADDING_TRANSFORMATION = "AES/CBC/NoPadding";

    @Nullable
    public static String encrypt(String plainText, String encryptionKey, String salt) {
        Preconditions.checkNotNull((Object)plainText, (Object)"Plain text must not be null.");
        Preconditions.checkNotNull((Object)encryptionKey, (Object)"Encryption key must not be null.");
        Preconditions.checkNotNull((Object)salt, (Object)"Salt must not be null.");
        try {
            Cipher cipher = Cipher.getInstance(CIPHER_TRANSFORMATION);
            SecretKeySpec key = new SecretKeySpec(AESTools.adjustToIdealKeyLength(encryptionKey), "AES");
            cipher.init(1, (Key)key, new IvParameterSpec(salt.getBytes(StandardCharsets.UTF_8)));
            return Hex.encodeHexString((byte[])cipher.doFinal(plainText.getBytes(StandardCharsets.UTF_8)));
        }
        catch (Exception e) {
            LOG.error("Could not encrypt value.", (Throwable)e);
            return null;
        }
    }

    @Nullable
    public static String decrypt(String cipherText, String encryptionKey, String salt) {
        try {
            return AESTools.tryDecrypt(cipherText, encryptionKey, salt);
        }
        catch (Exception ex) {
            LOG.error("Could not decrypt (legacy) value.", (Throwable)ex);
            return null;
        }
    }

    public static String tryDecrypt(String cipherText, String encryptionKey, String salt) throws InvalidCipherTextException, GeneralSecurityException {
        Preconditions.checkNotNull((Object)cipherText, (Object)"Cipher text must not be null.");
        Preconditions.checkNotNull((Object)encryptionKey, (Object)"Encryption key must not be null.");
        Preconditions.checkNotNull((Object)salt, (Object)"Salt must not be null.");
        try {
            Cipher cipher = Cipher.getInstance(CIPHER_TRANSFORMATION);
            SecretKeySpec key = new SecretKeySpec(AESTools.adjustToIdealKeyLength(encryptionKey), "AES");
            cipher.init(2, (Key)key, new IvParameterSpec(salt.getBytes(StandardCharsets.UTF_8)));
            return new String(cipher.doFinal(Hex.decodeHex((String)cipherText)), StandardCharsets.UTF_8);
        }
        catch (Exception ignored) {
            return AESTools.decryptLegacy(cipherText, encryptionKey, salt);
        }
    }

    private static String decryptLegacy(String cipherText, String encryptionKey, String salt) throws GeneralSecurityException, InvalidCipherTextException {
        Cipher cipher = Cipher.getInstance(CIPHER_NO_PADDING_TRANSFORMATION);
        SecretKeySpec key = new SecretKeySpec(AESTools.adjustToIdealKeyLength(encryptionKey), "AES");
        cipher.init(2, (Key)key, new IvParameterSpec(salt.getBytes(StandardCharsets.UTF_8)));
        try {
            byte[] decrypted = cipher.doFinal(Hex.decodeHex((String)cipherText));
            int padCount = new ISO10126d2Padding().padCount(decrypted);
            return new String(Arrays.copyOf(decrypted, decrypted.length - padCount), StandardCharsets.UTF_8);
        }
        catch (DecoderException e) {
            throw new IllegalArgumentException("Unable to decode ciphertext", e);
        }
    }

    @Nullable
    public static String encryptSiv(String plainText, byte[] encryptionKey) {
        AESTools.validateTextAndEncryptionKey(plainText, encryptionKey);
        try {
            byte[] cipherBytes = SIV_MODE.encrypt(Arrays.copyOf(encryptionKey, 16), Arrays.copyOfRange(encryptionKey, 16, 32), plainText.getBytes(StandardCharsets.UTF_8), (byte[][])new byte[0][]);
            return Hex.encodeHexString((byte[])cipherBytes);
        }
        catch (Exception e) {
            LOG.error("Couldn't encrypt value", (Throwable)e);
            return null;
        }
    }

    @Nullable
    public static String decryptSiv(String cipherText, byte[] encryptionKey) {
        AESTools.validateTextAndEncryptionKey(cipherText, encryptionKey);
        try {
            byte[] plainBytes = SIV_MODE.decrypt(Arrays.copyOf(encryptionKey, 16), Arrays.copyOfRange(encryptionKey, 16, 32), Hex.decodeHex((String)cipherText), (byte[][])new byte[0][]);
            return new String(plainBytes, StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            LOG.error("Couldn't decrypt value", (Throwable)e);
            return null;
        }
    }

    public static String generateNewSalt() {
        SecureRandom random = new SecureRandom();
        byte[] saltBytes = new byte[8];
        random.nextBytes(saltBytes);
        return Hex.encodeHexString((byte[])saltBytes);
    }

    private static void validateTextAndEncryptionKey(String text, byte[] encryptionKey) {
        if (text == null) {
            throw new IllegalArgumentException("text value cannot be null");
        }
        if (encryptionKey == null || encryptionKey.length < 32) {
            throw new IllegalArgumentException("encryptionKey cannot be null and must be at least 32 bytes long");
        }
    }

    private static int desiredKeyLength(byte[] input) {
        int length = input.length;
        if (length == 16 || length == 24 || length == 32) {
            return length;
        }
        if (length < 16) {
            return 16;
        }
        if (length > 32) {
            return 32;
        }
        return (length / 8 + 1) * 8;
    }

    private static byte[] cutToLength(byte[] input, int length) {
        Preconditions.checkArgument((input.length >= length ? 1 : 0) != 0, (Object)"Input string must be greater or of desired length");
        return input.length > length ? Arrays.copyOfRange(input, 0, length) : input;
    }

    private static byte[] padToLength(byte[] input, int length) {
        Preconditions.checkArgument((input.length < length ? 1 : 0) != 0, (Object)"Input string must be smaller than desired length");
        byte[] result = new byte[length];
        System.arraycopy(input, 0, result, 0, input.length);
        return result;
    }

    private static byte[] cutOrPadToLength(byte[] input, int length) {
        if (input.length == length) {
            return input;
        }
        return input.length > length ? AESTools.cutToLength(input, length) : AESTools.padToLength(input, length);
    }

    private static byte[] adjustToIdealKeyLength(String input) {
        Preconditions.checkNotNull((Object)input);
        byte[] inputAsBytes = input.getBytes(StandardCharsets.UTF_8);
        int desiredLength = AESTools.desiredKeyLength(inputAsBytes);
        return AESTools.cutOrPadToLength(inputAsBytes, desiredLength);
    }
}

