/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.shared.bindings.providers;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.concurrent.ExecutionException;
import javax.net.SocketFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import okhttp3.OkHttpClient;
import org.graylog2.security.DefaultX509TrustManager;
import org.graylog2.security.TrustAllX509TrustManager;
import org.graylog2.shared.bindings.providers.OkHttpClientProvider;
import org.graylog2.shared.bindings.providers.TcpKeepAliveSSLSocketFactory;
import org.graylog2.shared.bindings.providers.TcpKeepAliveSocketFactory;

@Singleton
public class ParameterizedHttpClientProvider {
    private final LoadingCache<Parameters, OkHttpClient> cache;
    private final OkHttpClientProvider okHttpClientProvider;
    private final X509TrustManager insecureTrustManager;
    private final SSLSocketFactory insecureSocketFactory;
    private X509TrustManager trustManager;
    private SSLSocketFactory sslSocketFactory;

    @Inject
    public ParameterizedHttpClientProvider(OkHttpClientProvider provider) throws NoSuchAlgorithmException, KeyManagementException, KeyStoreException {
        this.okHttpClientProvider = provider;
        this.cache = CacheBuilder.newBuilder().build(CacheLoader.from(this::buildHttpClient));
        this.insecureTrustManager = new TrustAllX509TrustManager();
        SSLContext insecureSSLContext = SSLContext.getInstance("TLS");
        insecureSSLContext.init(null, new TrustManager[]{this.insecureTrustManager}, new SecureRandom());
        this.insecureSocketFactory = insecureSSLContext.getSocketFactory();
        this.sslSocketFactory = SSLContext.getDefault().getSocketFactory();
        this.trustManager = new DefaultX509TrustManager("ignored");
    }

    @VisibleForTesting
    public ParameterizedHttpClientProvider(OkHttpClientProvider provider, SSLSocketFactory sslSocketFactory, X509TrustManager trustManager) throws NoSuchAlgorithmException, KeyStoreException, KeyManagementException {
        this(provider);
        this.trustManager = trustManager;
        this.sslSocketFactory = sslSocketFactory;
    }

    public OkHttpClient get(boolean keepAlive, boolean skipTLSVerify) {
        try {
            return (OkHttpClient)this.cache.get((Object)Parameters.fromBoolean(keepAlive, skipTLSVerify));
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    private OkHttpClient buildHttpClient(Parameters parameters) {
        OkHttpClient.Builder builder = this.okHttpClientProvider.get().newBuilder();
        switch (parameters) {
            case NONE: {
                this.withDefaultSocketFactory(builder);
                break;
            }
            case KEEPALIVE: {
                this.withKeepAlive(builder);
                break;
            }
            case SKIP_TLS_VERIFY: {
                this.withSkipTLSVerification(builder);
                break;
            }
            case SKIP_TLS_VERIFY_AND_KEEPALIVE: {
                this.withSkipTLSVerificationAndKeepAlive(builder);
            }
        }
        return builder.build();
    }

    private OkHttpClient.Builder withDefaultSocketFactory(OkHttpClient.Builder builder) {
        builder.sslSocketFactory(this.sslSocketFactory, this.trustManager);
        return builder;
    }

    private OkHttpClient.Builder withKeepAlive(OkHttpClient.Builder builder) {
        builder.socketFactory((SocketFactory)new TcpKeepAliveSocketFactory(SocketFactory.getDefault()));
        builder.sslSocketFactory((SSLSocketFactory)new TcpKeepAliveSSLSocketFactory(this.sslSocketFactory), this.trustManager);
        return builder;
    }

    private OkHttpClient.Builder withSkipTLSVerification(OkHttpClient.Builder builder) {
        builder.sslSocketFactory(this.insecureSocketFactory, this.insecureTrustManager);
        builder.hostnameVerifier((h, s) -> true);
        return builder;
    }

    private OkHttpClient.Builder withSkipTLSVerificationAndKeepAlive(OkHttpClient.Builder builder) {
        builder.socketFactory((SocketFactory)new TcpKeepAliveSocketFactory(SocketFactory.getDefault()));
        builder.sslSocketFactory((SSLSocketFactory)new TcpKeepAliveSSLSocketFactory(this.insecureSocketFactory), this.insecureTrustManager);
        builder.hostnameVerifier((h, s) -> true);
        return builder;
    }

    static enum Parameters {
        NONE,
        KEEPALIVE,
        SKIP_TLS_VERIFY,
        SKIP_TLS_VERIFY_AND_KEEPALIVE;


        static Parameters fromBoolean(boolean keepAlive, boolean skipTLSVerify) {
            if (keepAlive) {
                if (skipTLSVerify) {
                    return SKIP_TLS_VERIFY_AND_KEEPALIVE;
                }
                return KEEPALIVE;
            }
            if (skipTLSVerify) {
                return SKIP_TLS_VERIFY;
            }
            return NONE;
        }
    }
}

