/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.shared.security;

import com.google.common.base.Strings;
import jakarta.annotation.Priority;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.container.ContainerRequestFilter;
import jakarta.ws.rs.container.ContainerResponseContext;
import jakarta.ws.rs.container.ContainerResponseFilter;
import jakarta.ws.rs.core.MultivaluedMap;
import java.io.IOException;
import java.util.Optional;
import org.apache.shiro.util.ThreadContext;

@Priority(value=992)
public class ShiroRequestHeadersBinder
implements ContainerRequestFilter,
ContainerResponseFilter {
    public static final String REQUEST_HEADERS = "REQUEST_HEADERS";

    public void filter(ContainerRequestContext requestContext) throws IOException {
        MultivaluedMap headers = requestContext.getHeaders();
        ThreadContext.put((Object)REQUEST_HEADERS, (Object)headers);
    }

    public static Optional<String> getHeaderFromThreadContext(String headerName) {
        String header;
        MultivaluedMap requestHeaders = (MultivaluedMap)ThreadContext.get((Object)REQUEST_HEADERS);
        if (requestHeaders != null && !Strings.isNullOrEmpty((String)(header = (String)requestHeaders.getFirst((Object)headerName)))) {
            return Optional.of(header);
        }
        return Optional.empty();
    }

    public void filter(ContainerRequestContext requestContext, ContainerResponseContext responseContext) throws IOException {
        ThreadContext.remove((Object)REQUEST_HEADERS);
    }
}

