/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.storage;

import jakarta.inject.Inject;
import jakarta.inject.Provider;
import java.util.Map;
import org.graylog2.storage.DetectedSearchVersion;
import org.graylog2.storage.SearchVersion;
import org.graylog2.storage.UnsupportedSearchException;

public class VersionAwareProvider<T>
implements Provider<T> {
    private final SearchVersion elasticsearchMajorVersion;
    private final Map<SearchVersion, Provider<T>> pluginBindings;

    @Inject
    public VersionAwareProvider(@DetectedSearchVersion SearchVersion indexerVersion, Map<SearchVersion, Provider<T>> pluginBindings) {
        this.elasticsearchMajorVersion = this.majorVersionFrom(indexerVersion);
        this.pluginBindings = pluginBindings;
    }

    public T get() {
        Provider<T> provider = this.pluginBindings.get(this.elasticsearchMajorVersion);
        if (provider == null) {
            throw new UnsupportedSearchException(this.elasticsearchMajorVersion, this.getClass().getName());
        }
        return (T)provider.get();
    }

    private SearchVersion majorVersionFrom(SearchVersion version) {
        return version.major();
    }
}

