/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.system.traffic;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableMap;
import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import jakarta.inject.Inject;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.bson.conversions.Bson;
import org.bson.types.ObjectId;
import org.graylog2.bindings.providers.MongoJackObjectMapperProvider;
import org.graylog2.database.MongoConnection;
import org.graylog2.plugin.Tools;
import org.graylog2.plugin.system.NodeId;
import org.graylog2.system.traffic.AutoValue_TrafficCounterService_TrafficHistogram;
import org.graylog2.system.traffic.TrafficDto;
import org.joda.time.DateTime;
import org.joda.time.Duration;
import org.joda.time.ReadableDuration;
import org.mongojack.DBCursor;
import org.mongojack.DBQuery;
import org.mongojack.DBUpdate;
import org.mongojack.JacksonDBCollection;
import org.mongojack.UpdateOperationValue;
import org.mongojack.WriteResult;
import org.mongojack.internal.update.SingleUpdateOperationValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrafficCounterService {
    private static final Logger LOG = LoggerFactory.getLogger(TrafficCounterService.class);
    private static final String BUCKET = "bucket";
    private final JacksonDBCollection<TrafficDto, ObjectId> db;

    @Inject
    public TrafficCounterService(MongoConnection mongoConnection, MongoJackObjectMapperProvider mapper) {
        this.db = JacksonDBCollection.wrap(mongoConnection.getDatabase().getCollection("traffic"), TrafficDto.class, ObjectId.class, mapper.get());
        this.db.createIndex((DBObject)new BasicDBObject(BUCKET, (Object)1), (DBObject)new BasicDBObject("unique", (Object)true));
    }

    private static DateTime getDayBucketStart(DateTime observationTime) {
        return observationTime.withHourOfDay(0).withMinuteOfHour(0).withSecondOfMinute(0).withMillisOfSecond(0);
    }

    private static DateTime getHourBucketStart(DateTime observationTime) {
        return observationTime.withMinuteOfHour(0).withSecondOfMinute(0).withMillisOfSecond(0);
    }

    public void updateTraffic(DateTime observationTime, NodeId nodeId, long inLastMinute, long outLastMinute, long decodedLastMinute) {
        DateTime dayBucket = TrafficCounterService.getHourBucketStart(observationTime);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Updating traffic for node {} at {}:  in/decoded/out {}/{}/{} bytes", new Object[]{nodeId, dayBucket, inLastMinute, decodedLastMinute, outLastMinute});
        }
        String escapedNodeId = nodeId.toEscapedString();
        WriteResult<TrafficDto, ObjectId> update = this.db.update((Bson)DBQuery.is((String)BUCKET, (Object)dayBucket), (Bson)new DBUpdate.Builder().addOperation("$inc", "input." + escapedNodeId, (UpdateOperationValue)new SingleUpdateOperationValue(false, false, (Object)inLastMinute)).addOperation("$inc", "output." + escapedNodeId, (UpdateOperationValue)new SingleUpdateOperationValue(false, false, (Object)outLastMinute)).addOperation("$inc", "decoded." + escapedNodeId, (UpdateOperationValue)new SingleUpdateOperationValue(false, false, (Object)decodedLastMinute)), true, false);
        if (update.getN() == 0) {
            LOG.warn("Unable to update traffic of node {}: {}", (Object)nodeId, update);
        }
    }

    public TrafficHistogram clusterTrafficOfLastDays(Duration daysToIncludeDuration, Interval interval) {
        return this.clusterTrafficOfLastDays(daysToIncludeDuration, interval, true);
    }

    public TrafficHistogram clusterTrafficOfLastDays(Duration daysToIncludeDuration, Interval interval, boolean includeToday) {
        ImmutableMap.Builder inputBuilder = ImmutableMap.builder();
        ImmutableMap.Builder outputBuilder = ImmutableMap.builder();
        ImmutableMap.Builder decodedBuilder = ImmutableMap.builder();
        DateTime now = Tools.nowUTC();
        DateTime to = includeToday ? now : TrafficCounterService.getDayBucketStart(now).minusMillis(1);
        DateTime from = TrafficCounterService.getDayBucketStart(now).minus((ReadableDuration)daysToIncludeDuration);
        DBQuery.Query query = DBQuery.and((DBQuery.Query[])new DBQuery.Query[]{DBQuery.lessThanEquals((String)BUCKET, (Object)to), DBQuery.greaterThanEquals((String)BUCKET, (Object)from)});
        DBCursor<TrafficDto> cursor = this.db.find((Bson)query);
        try {
            cursor.forEach(trafficDto -> {
                inputBuilder.put((Object)trafficDto.bucket(), (Object)trafficDto.input().values().stream().mapToLong(Long::valueOf).sum());
                outputBuilder.put((Object)trafficDto.bucket(), (Object)trafficDto.output().values().stream().mapToLong(Long::valueOf).sum());
                decodedBuilder.put((Object)trafficDto.bucket(), (Object)trafficDto.decoded().values().stream().mapToLong(Long::valueOf).sum());
            });
            Object inputHistogram = inputBuilder.build();
            Object outputHistogram = outputBuilder.build();
            Object decodedHistogram = decodedBuilder.build();
            if (interval == Interval.DAILY) {
                inputHistogram = this.aggregateToDaily((Map<DateTime, Long>)inputHistogram);
                outputHistogram = this.aggregateToDaily((Map<DateTime, Long>)outputHistogram);
                decodedHistogram = this.aggregateToDaily((Map<DateTime, Long>)decodedHistogram);
            }
            TrafficHistogram trafficHistogram = TrafficHistogram.create(from, to, (Map<DateTime, Long>)inputHistogram, (Map<DateTime, Long>)outputHistogram, (Map<DateTime, Long>)decodedHistogram);
            if (cursor != null) {
                cursor.close();
            }
            return trafficHistogram;
        }
        catch (Throwable throwable) {
            try {
                if (cursor != null) {
                    try {
                        cursor.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (Exception e) {
                LOG.error("Unable to load traffic data range {} to {}", (Object)from, (Object)to);
                throw e;
            }
        }
    }

    private TreeMap<DateTime, Long> aggregateToDaily(Map<DateTime, Long> histogram) {
        return histogram.entrySet().stream().collect(Collectors.groupingBy(entry -> ((DateTime)entry.getKey()).withTimeAtStartOfDay(), TreeMap::new, Collectors.mapping(Map.Entry::getValue, Collectors.summingLong(Long::valueOf))));
    }

    public static enum Interval {
        HOURLY,
        DAILY;

    }

    @JsonAutoDetect
    @AutoValue
    public static abstract class TrafficHistogram {
        @JsonCreator
        public static TrafficHistogram create(@JsonProperty(value="from") DateTime from, @JsonProperty(value="to") DateTime to, @JsonProperty(value="input") Map<DateTime, Long> input, @JsonProperty(value="output") Map<DateTime, Long> output, @JsonProperty(value="decoded") Map<DateTime, Long> decoded) {
            return new AutoValue_TrafficCounterService_TrafficHistogram(from, to, input, output, decoded);
        }

        @JsonProperty
        public abstract DateTime from();

        @JsonProperty
        public abstract DateTime to();

        @JsonProperty
        public abstract Map<DateTime, Long> input();

        @JsonProperty
        public abstract Map<DateTime, Long> output();

        @JsonProperty
        public abstract Map<DateTime, Long> decoded();
    }
}

