/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.aws.config;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import jakarta.inject.Inject;
import jakarta.validation.Valid;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.graylog.aws.config.AWSPluginConfiguration;
import org.graylog.aws.config.AWSPluginConfigurationUpdate;
import org.graylog2.Configuration;
import org.graylog2.audit.jersey.AuditEvent;
import org.graylog2.plugin.cluster.ClusterConfigService;
import org.graylog2.plugin.rest.PluginRestResource;
import org.graylog2.shared.rest.resources.RestResource;

@Api(value="AWS/Config", description="Manage AWS Config settings")
@Path(value="/config")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@RequiresAuthentication
public class AWSConfigurationResource
extends RestResource
implements PluginRestResource {
    private final ClusterConfigService clusterConfigService;
    private final Configuration systemConfiguration;

    @Inject
    public AWSConfigurationResource(ClusterConfigService clusterConfigService, Configuration systemConfiguration) {
        this.clusterConfigService = clusterConfigService;
        this.systemConfiguration = systemConfiguration;
    }

    @PUT
    @ApiOperation(value="Updates the AWS default configuration.")
    @RequiresPermissions(value={"clusterconfigentry:create", "clusterconfigentry:edit"})
    @AuditEvent(type="server:cluster_configuration:update")
    public Response updateConfig(@Valid AWSPluginConfigurationUpdate update) {
        AWSPluginConfiguration existingConfiguration = this.clusterConfigService.getOrDefault(AWSPluginConfiguration.class, AWSPluginConfiguration.createDefault());
        AWSPluginConfiguration.Builder newConfigBuilder = existingConfiguration.toBuilder().lookupsEnabled(update.lookupsEnabled()).lookupRegions(update.lookupRegions()).accessKey(update.accessKey()).proxyEnabled(update.proxyEnabled());
        AWSPluginConfiguration newConfiguration = update.secretKey().map(secretKey -> newConfigBuilder.secretKey((String)secretKey, this.systemConfiguration.getPasswordSecret())).orElse(newConfigBuilder).build();
        this.clusterConfigService.write(newConfiguration);
        return Response.accepted((Object)newConfiguration).build();
    }
}

