/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.events.processor.aggregation;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import org.graylog.events.processor.EventProcessorParametersWithTimerange;
import org.graylog.events.processor.aggregation.AutoValue_AggregationEventProcessorParameters;
import org.graylog2.plugin.indexer.searches.timeranges.AbsoluteRange;
import org.graylog2.plugin.indexer.searches.timeranges.InvalidRangeParametersException;
import org.graylog2.plugin.indexer.searches.timeranges.RelativeRange;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;

@JsonTypeName(value="aggregation-v1")
@JsonDeserialize(builder=Builder.class)
@AutoValue
public abstract class AggregationEventProcessorParameters
implements EventProcessorParametersWithTimerange {
    private static final String FIELD_STREAMS = "streams";
    private static final String FIELD_BATCH_SIZE = "batch_size";

    @JsonProperty(value="streams")
    public abstract ImmutableSet<String> streams();

    @JsonProperty(value="batch_size")
    public abstract int batchSize();

    @Override
    public EventProcessorParametersWithTimerange withTimerange(DateTime from, DateTime to) {
        Objects.requireNonNull(from, "from cannot be null");
        Objects.requireNonNull(to, "to cannot be null");
        Preconditions.checkArgument((boolean)to.isAfter((ReadableInstant)from), (Object)"to must be after from");
        return ((Builder)this.toBuilder().timerange(AbsoluteRange.create(from, to))).build();
    }

    public abstract Builder toBuilder();

    public static Builder builder() {
        return Builder.create();
    }

    @AutoValue.Builder
    public static abstract class Builder
    implements EventProcessorParametersWithTimerange.Builder<Builder> {
        @JsonCreator
        public static Builder create() {
            RelativeRange timerange;
            try {
                timerange = RelativeRange.create(3600);
            }
            catch (InvalidRangeParametersException e) {
                throw new RuntimeException(e);
            }
            return ((Builder)new AutoValue_AggregationEventProcessorParameters.Builder().type("aggregation-v1").timerange(timerange)).streams(Collections.emptySet()).batchSize(500);
        }

        @JsonProperty(value="streams")
        public abstract Builder streams(Set<String> var1);

        @JsonProperty(value="batch_size")
        public abstract Builder batchSize(int var1);

        public abstract AggregationEventProcessorParameters build();
    }
}

