/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.failure;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Meter;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.graylog.failure.FailureBatch;
import org.graylog2.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
class FailureSubmissionQueue {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final BlockingQueue<FailureBatch> queue;
    private final Configuration configuration;
    private final Meter submittedFailureBatches;
    private final Meter submittedFailures;
    private final Meter consumedFailureBatches;
    private final Meter consumedFailures;

    @Inject
    FailureSubmissionQueue(Configuration configuration, MetricRegistry metricRegistry) {
        this.queue = new LinkedBlockingQueue<FailureBatch>(configuration.getFailureHandlingQueueCapacity());
        this.configuration = configuration;
        this.submittedFailureBatches = metricRegistry.meter(MetricRegistry.name(FailureSubmissionQueue.class, (String[])new String[]{"submittedFailureBatches"}));
        this.submittedFailures = metricRegistry.meter(MetricRegistry.name(FailureSubmissionQueue.class, (String[])new String[]{"submittedFailures"}));
        this.consumedFailureBatches = metricRegistry.meter(MetricRegistry.name(FailureSubmissionQueue.class, (String[])new String[]{"consumedFailureBatches"}));
        this.consumedFailures = metricRegistry.meter(MetricRegistry.name(FailureSubmissionQueue.class, (String[])new String[]{"consumedFailures"}));
        metricRegistry.register(MetricRegistry.name(FailureSubmissionQueue.class, (String[])new String[]{"queueSize"}), (Metric)((Gauge)this.queue::size));
    }

    void submitBlocking(FailureBatch batch) throws InterruptedException {
        this.queue.put(batch);
        if (this.queueSize() == this.configuration.getFailureHandlingQueueCapacity()) {
            this.logger.debug("The queue is full! Current capacity: {}", (Object)this.configuration.getFailureHandlingQueueCapacity());
        }
        this.submittedFailureBatches.mark();
        this.submittedFailures.mark((long)batch.size());
    }

    void logStats(String tag) {
        this.logger.info("[{}] Total number of submitted batches: {} ({} failures), total number of consumed batches: {} ({} failures)", new Object[]{tag, this.submittedFailureBatches.getCount(), this.submittedFailures.getCount(), this.consumedFailureBatches.getCount(), this.consumedFailures.getCount()});
    }

    FailureBatch consumeBlocking() throws InterruptedException {
        FailureBatch fb = this.queue.take();
        this.consumedFailureBatches.mark();
        this.consumedFailures.mark((long)fb.size());
        return fb;
    }

    @Nullable
    FailureBatch consumeBlockingWithTimeout(long timeoutInMs) throws InterruptedException {
        FailureBatch fb = this.queue.poll(timeoutInMs, TimeUnit.MILLISECONDS);
        if (fb != null) {
            this.consumedFailureBatches.mark();
            this.consumedFailures.mark((long)fb.size());
        }
        return fb;
    }

    int queueSize() {
        return this.queue.size();
    }
}

