/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.integrations.inputs.paloalto9;

import com.google.common.collect.Sets;
import java.util.SortedSet;
import java.util.TreeSet;
import org.graylog.integrations.inputs.paloalto.PaloAltoFieldTemplate;
import org.graylog.integrations.inputs.paloalto.PaloAltoFieldType;
import org.graylog.integrations.inputs.paloalto.PaloAltoMessageTemplate;

public class PaloAlto9xTemplates {
    private static PaloAltoMessageTemplate toTemplate(SortedSet<PaloAltoFieldTemplate> fields) {
        PaloAltoMessageTemplate template = new PaloAltoMessageTemplate();
        template.setFields(fields);
        return template;
    }

    public static PaloAltoMessageTemplate configTemplate() {
        TreeSet fields = Sets.newTreeSet();
        fields.add(PaloAltoFieldTemplate.create("event_created", 1, PaloAltoFieldType.TIMESTAMP));
        fields.add(PaloAltoFieldTemplate.create("host_id", 2, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("event_log_name", 3, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("pan_log_subtype", 4, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("timestamp", 6, PaloAltoFieldType.TIMESTAMP));
        fields.add(PaloAltoFieldTemplate.create("source_reference", 7, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("host_virtfw_id", 8, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("user_command", 9, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("user_name", 10, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("vendor_signin_protocol", 11, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("vendor_event_outcome", 12, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("user_command_path", 13, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("pan_before_change_detail", 14, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("pan_after_change_detail", 15, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("event_uid", 16, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("pan_log_panorama", 17, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("pan_dev_group_level_1", 18, PaloAltoFieldType.LONG));
        fields.add(PaloAltoFieldTemplate.create("pan_dev_group_level_2", 19, PaloAltoFieldType.LONG));
        fields.add(PaloAltoFieldTemplate.create("pan_dev_group_level_3", 20, PaloAltoFieldType.LONG));
        fields.add(PaloAltoFieldTemplate.create("pan_dev_group_level_4", 21, PaloAltoFieldType.LONG));
        fields.add(PaloAltoFieldTemplate.create("host_virtfw_hostname", 22, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("host_hostname", 23, PaloAltoFieldType.STRING));
        return PaloAlto9xTemplates.toTemplate(fields);
    }

    public static PaloAltoMessageTemplate correlationTemplate() {
        TreeSet fields = Sets.newTreeSet();
        fields.add(PaloAltoFieldTemplate.create("event_created", 1, PaloAltoFieldType.TIMESTAMP));
        fields.add(PaloAltoFieldTemplate.create("host_id", 2, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("event_log_name", 3, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("pan_log_subtype", 4, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("timestamp", 6, PaloAltoFieldType.TIMESTAMP));
        fields.add(PaloAltoFieldTemplate.create("source_ip", 7, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("user_name", 8, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("host_virtfw_id", 9, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("threat_category", 10, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("event_severity", 11, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("pan_dev_group_level_1", 12, PaloAltoFieldType.LONG));
        fields.add(PaloAltoFieldTemplate.create("pan_dev_group_level_2", 13, PaloAltoFieldType.LONG));
        fields.add(PaloAltoFieldTemplate.create("pan_dev_group_level_3", 14, PaloAltoFieldType.LONG));
        fields.add(PaloAltoFieldTemplate.create("pan_dev_group_level_4", 15, PaloAltoFieldType.LONG));
        fields.add(PaloAltoFieldTemplate.create("host_virtfw_hostname", 16, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("host_hostname", 17, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("host_virtfw_uid", 18, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("pan_objectname", 19, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("pan_object_id", 20, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("pan_evidence", 21, PaloAltoFieldType.STRING));
        return PaloAlto9xTemplates.toTemplate(fields);
    }

    public static PaloAltoMessageTemplate hipTemplate() {
        TreeSet fields = Sets.newTreeSet();
        fields.add(PaloAltoFieldTemplate.create("event_created", 1, PaloAltoFieldType.TIMESTAMP));
        fields.add(PaloAltoFieldTemplate.create("event_observer_uid", 2, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("event_log_name", 3, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("pan_log_subtype", 4, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("timestamp", 6, PaloAltoFieldType.TIMESTAMP));
        fields.add(PaloAltoFieldTemplate.create("user_name", 7, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("host_virtfw_id", 8, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("host_hostname", 9, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("host_type", 10, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("host_ip", 11, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("pan_hip", 12, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("event_repeat_count", 13, PaloAltoFieldType.LONG));
        fields.add(PaloAltoFieldTemplate.create("pan_hip_type", 14, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("event_uid", 17, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("pan_log_panorama", 18, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("pan_dev_group_level_1", 19, PaloAltoFieldType.LONG));
        fields.add(PaloAltoFieldTemplate.create("pan_dev_group_level_2", 20, PaloAltoFieldType.LONG));
        fields.add(PaloAltoFieldTemplate.create("pan_dev_group_level_3", 21, PaloAltoFieldType.LONG));
        fields.add(PaloAltoFieldTemplate.create("pan_dev_group_level_4", 22, PaloAltoFieldType.LONG));
        fields.add(PaloAltoFieldTemplate.create("host_virtfw_hostname", 23, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("event_observer_hostname", 24, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("host_virtfw_uid", 25, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("host_ipv6", 26, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("pan_gp_hostid", 27, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("host_id", 28, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("source_mac", 29, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("pan_high_res_time", 30, PaloAltoFieldType.STRING));
        return PaloAlto9xTemplates.toTemplate(fields);
    }

    public static PaloAltoMessageTemplate globalProtectPre913Template() {
        TreeSet fields = Sets.newTreeSet();
        fields.add(PaloAltoFieldTemplate.create("event_received_time", 1, PaloAltoFieldType.TIMESTAMP));
        fields.add(PaloAltoFieldTemplate.create("host_id", 2, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("event_uid", 3, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("pan_log_panorama", 4, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("event_log_name", 5, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("timestamp", 8, PaloAltoFieldType.TIMESTAMP));
        fields.add(PaloAltoFieldTemplate.create("host_virtfw_id", 9, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("pan_event_name", 10, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("pan_tunnel_stage", 11, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("pan_auth_method", 12, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("network_tunnel_type", 13, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("source_user", 14, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("pan_source_region", 15, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("source_hostname", 16, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("vendor_public_ip", 17, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("vendor_public_ipv6", 18, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("vendor_private_ip", 19, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("vendor_private_ipv6", 20, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("pan_gp_hostid", 21, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("pan_gp_client_version", 23, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("host_type", 24, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("host_type_version", 25, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("event_repeat_count", 26, PaloAltoFieldType.LONG));
        fields.add(PaloAltoFieldTemplate.create("pan_gp_reason", 27, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("pan_gp_error", 28, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("pan_gp_error_extended", 29, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("vendor_event_action", 30, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("pan_gp_location_name", 31, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("network_tunnel_duration", 32, PaloAltoFieldType.LONG));
        fields.add(PaloAltoFieldTemplate.create("pan_gp_connect_method", 33, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("pan_gp_error_code", 34, PaloAltoFieldType.LONG));
        fields.add(PaloAltoFieldTemplate.create("pan_gp_hostname", 35, PaloAltoFieldType.STRING));
        return PaloAlto9xTemplates.toTemplate(fields);
    }

    public static PaloAltoMessageTemplate globalProtect913Template() {
        TreeSet fields = Sets.newTreeSet();
        fields.add(PaloAltoFieldTemplate.create("event_received_time", 1, PaloAltoFieldType.TIMESTAMP));
        fields.add(PaloAltoFieldTemplate.create("host_id", 2, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("event_log_name", 3, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("pan_log_subtype", 4, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("timestamp", 6, PaloAltoFieldType.TIMESTAMP));
        fields.add(PaloAltoFieldTemplate.create("host_virtfw_id", 7, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("pan_event_name", 8, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("pan_tunnel_stage", 9, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("pan_auth_method", 10, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("network_tunnel_type", 11, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("user_name", 12, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("pan_source_region", 13, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("source_hostname", 14, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("vendor_public_ip", 15, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("vendor_public_ipv6", 16, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("vendor_private_ip", 17, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("vendor_private_ipv6", 18, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("pan_gp_hostid", 19, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("source_id", 20, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("pan_gp_client_version", 21, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("source_os_name", 22, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("source_os_version", 23, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("event_repeat_count", 24, PaloAltoFieldType.LONG));
        fields.add(PaloAltoFieldTemplate.create("pan_gp_reason", 25, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("event_error_description", 26, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("pan_gp_error_extended", 27, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("vendor_event_outcome", 28, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("pan_gp_location_name", 29, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("network_tunnel_duration", 30, PaloAltoFieldType.LONG));
        fields.add(PaloAltoFieldTemplate.create("pan_gp_connect_method", 31, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("event_error_code", 32, PaloAltoFieldType.LONG));
        fields.add(PaloAltoFieldTemplate.create("destination_hostname", 33, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("event_uid", 34, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("pan_log_panorama", 35, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("pan_high_res_time", 36, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("pan_selection_type", 37, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("application_response_time", 38, PaloAltoFieldType.LONG));
        fields.add(PaloAltoFieldTemplate.create("pan_gateway_priority", 39, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("pan_attempted_gateways", 40, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("pan_gateway", 41, PaloAltoFieldType.STRING));
        return PaloAlto9xTemplates.toTemplate(fields);
    }

    public static PaloAltoMessageTemplate systemTemplate() {
        TreeSet fields = Sets.newTreeSet();
        fields.add(PaloAltoFieldTemplate.create("event_created", 1, PaloAltoFieldType.TIMESTAMP));
        fields.add(PaloAltoFieldTemplate.create("host_id", 2, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("event_log_name", 3, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("pan_log_subtype", 4, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("timestamp", 6, PaloAltoFieldType.TIMESTAMP));
        fields.add(PaloAltoFieldTemplate.create("host_virtfw_id", 7, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("pan_event_name", 8, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("pan_event_object", 9, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("pan_module", 12, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("event_severity", 13, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("vendor_event_description", 14, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("event_uid", 15, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("pan_log_panorama", 16, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("pan_dev_group_level_1", 17, PaloAltoFieldType.LONG));
        fields.add(PaloAltoFieldTemplate.create("pan_dev_group_level_2", 18, PaloAltoFieldType.LONG));
        fields.add(PaloAltoFieldTemplate.create("pan_dev_group_level_3", 19, PaloAltoFieldType.LONG));
        fields.add(PaloAltoFieldTemplate.create("pan_dev_group_level_4", 20, PaloAltoFieldType.LONG));
        fields.add(PaloAltoFieldTemplate.create("host_virtfw_hostname", 21, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("host_hostname", 22, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("pan_high_res_time", 23, PaloAltoFieldType.STRING));
        return PaloAlto9xTemplates.toTemplate(fields);
    }

    public static PaloAltoMessageTemplate threatTemplate() {
        TreeSet fields = Sets.newTreeSet();
        fields.add(PaloAltoFieldTemplate.create("event_received_time", 1, PaloAltoFieldType.TIMESTAMP));
        fields.add(PaloAltoFieldTemplate.create("event_observer_id", 2, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("event_log_name", 3, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("pan_log_subtype", 4, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("timestamp", 6, PaloAltoFieldType.TIMESTAMP));
        fields.add(PaloAltoFieldTemplate.create("source_ip", 7, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("destination_ip", 8, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("source_nat_ip", 9, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("destination_nat_ip", 10, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("rule_name", 11, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("source_user_name", 12, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("destination_user_name", 13, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("application_name", 14, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("host_virtfw_id", 15, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("source_zone", 16, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("destination_zone", 17, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("network_interface_in", 18, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("network_interface_out", 19, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("pan_log_action", 20, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("session_id", 22, PaloAltoFieldType.LONG));
        fields.add(PaloAltoFieldTemplate.create("event_repeat_count", 23, PaloAltoFieldType.LONG));
        fields.add(PaloAltoFieldTemplate.create("source_port", 24, PaloAltoFieldType.LONG));
        fields.add(PaloAltoFieldTemplate.create("destination_port", 25, PaloAltoFieldType.LONG));
        fields.add(PaloAltoFieldTemplate.create("source_nat_port", 26, PaloAltoFieldType.LONG));
        fields.add(PaloAltoFieldTemplate.create("destination_nat_port", 27, PaloAltoFieldType.LONG));
        fields.add(PaloAltoFieldTemplate.create("pan_flags", 28, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("network_transport", 29, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("vendor_event_action", 30, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("alert_indicator", 31, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("alert_signature", 32, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("alert_category", 33, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("vendor_alert_severity", 34, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("pan_alert_direction", 35, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("event_uid", 36, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("pan_log_panorama", 37, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("source_location_name", 38, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("destination_location_name", 39, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("http_content_type", 41, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("pan_pcap_id", 42, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("pan_wildfire_hash", 43, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("pan_cloud_hostname", 44, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("pan_url_index", 45, PaloAltoFieldType.LONG));
        fields.add(PaloAltoFieldTemplate.create("http_user_agent_name", 46, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("file_type", 47, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("http_xff", 48, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("http_referrer", 49, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("source_user_email", 50, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("email_subject", 51, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("target_user_email", 52, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("pan_wildfire_report_id", 53, PaloAltoFieldType.LONG));
        fields.add(PaloAltoFieldTemplate.create("pan_dev_group_level_1", 54, PaloAltoFieldType.LONG));
        fields.add(PaloAltoFieldTemplate.create("pan_dev_group_level_2", 55, PaloAltoFieldType.LONG));
        fields.add(PaloAltoFieldTemplate.create("pan_dev_group_level_3", 56, PaloAltoFieldType.LONG));
        fields.add(PaloAltoFieldTemplate.create("pan_dev_group_level_4", 57, PaloAltoFieldType.LONG));
        fields.add(PaloAltoFieldTemplate.create("host_virtfw_hostname", 58, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("event_observer_hostname", 59, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("source_vsys_uuid", 61, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("destination_vsys_uuid", 62, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("http_method", 63, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("pan_tunnel_id", 64, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("pan_monitor_tag", 65, PaloAltoFieldType.LONG));
        fields.add(PaloAltoFieldTemplate.create("pan_parent_session_id", 66, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("pan_parent_start_time", 67, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("network_tunnel_type", 68, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("alert_category", 69, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("alert_definitions_version", 70, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("pan_assoc_id", 72, PaloAltoFieldType.LONG));
        fields.add(PaloAltoFieldTemplate.create("pan_ppid", 73, PaloAltoFieldType.LONG));
        fields.add(PaloAltoFieldTemplate.create("http_headers", 74, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("http_uri_category", 75, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("policy_uid", 76, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("pan_http2", 77, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("pan_dynusergroup_name", 78, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("http_xff", 79, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("source_category", 80, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("pan_source_profile", 81, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("source_device_model", 82, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("source_device_vendor", 83, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("source_os_name", 84, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("source_os_version", 85, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("source_hostname", 86, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("source_mac", 87, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("destination_category", 88, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("pan_destination_profile", 89, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("destination_device_model", 90, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("destination_device_vendor", 91, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("destination_os_name", 92, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("destination_os_version", 93, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("destination_hostname", 94, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("destination_mac", 95, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("container_id", 96, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("container_namespace", 97, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("container_name", 98, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("pan_src_edl", 99, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("pan_dst_edl", 100, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("pan_host_id", 101, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("pan_host_sn", 102, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("pan_domain_edl", 103, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("pan_src_dag", 104, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("pan_dst_dag", 105, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("pan_partial_hash", 106, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("pan_high_res_time", 107, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("vendor_event_outcome_reason", 108, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("pan_event_justification", 109, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("pan_nsdsai_sst", 110, PaloAltoFieldType.STRING));
        return PaloAlto9xTemplates.toTemplate(fields);
    }

    public static PaloAltoMessageTemplate trafficTemplate() {
        TreeSet fields = Sets.newTreeSet();
        fields.add(PaloAltoFieldTemplate.create("event_received_time", 1, PaloAltoFieldType.TIMESTAMP));
        fields.add(PaloAltoFieldTemplate.create("event_observer_id", 2, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("event_log_name", 3, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("pan_log_subtype", 4, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("timestamp", 6, PaloAltoFieldType.TIMESTAMP));
        fields.add(PaloAltoFieldTemplate.create("source_ip", 7, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("destination_ip", 8, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("source_nat_ip", 9, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("destination_nat_ip", 10, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("rule_name", 11, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("source_user_name", 12, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("destination_user_name", 13, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("application_name", 14, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("host_virtfw_id", 15, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("source_zone", 16, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("destination_zone", 17, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("network_interface_in", 18, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("network_interface_out", 19, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("pan_log_action", 20, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("session_id", 22, PaloAltoFieldType.LONG));
        fields.add(PaloAltoFieldTemplate.create("event_repeat_count", 23, PaloAltoFieldType.LONG));
        fields.add(PaloAltoFieldTemplate.create("source_port", 24, PaloAltoFieldType.LONG));
        fields.add(PaloAltoFieldTemplate.create("destination_port", 25, PaloAltoFieldType.LONG));
        fields.add(PaloAltoFieldTemplate.create("source_nat_port", 26, PaloAltoFieldType.LONG));
        fields.add(PaloAltoFieldTemplate.create("destination_nat_port", 27, PaloAltoFieldType.LONG));
        fields.add(PaloAltoFieldTemplate.create("pan_flags", 28, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("network_transport", 29, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("vendor_event_action", 30, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("network_bytes", 31, PaloAltoFieldType.LONG));
        fields.add(PaloAltoFieldTemplate.create("source_bytes_sent", 32, PaloAltoFieldType.LONG));
        fields.add(PaloAltoFieldTemplate.create("destination_bytes_sent", 33, PaloAltoFieldType.LONG));
        fields.add(PaloAltoFieldTemplate.create("network_packets", 34, PaloAltoFieldType.LONG));
        fields.add(PaloAltoFieldTemplate.create("event_start", 35, PaloAltoFieldType.TIMESTAMP));
        fields.add(PaloAltoFieldTemplate.create("event_duration", 36, PaloAltoFieldType.LONG));
        fields.add(PaloAltoFieldTemplate.create("http_uri_category", 37, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("event_uid", 39, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("pan_log_panorama", 40, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("source_location_name", 41, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("destination_location_name", 42, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("source_packets_sent", 44, PaloAltoFieldType.LONG));
        fields.add(PaloAltoFieldTemplate.create("destination_packets_sent", 45, PaloAltoFieldType.LONG));
        fields.add(PaloAltoFieldTemplate.create("pan_session_end_reason", 46, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("pan_dev_group_level_1", 47, PaloAltoFieldType.LONG));
        fields.add(PaloAltoFieldTemplate.create("pan_dev_group_level_2", 48, PaloAltoFieldType.LONG));
        fields.add(PaloAltoFieldTemplate.create("pan_dev_group_level_3", 49, PaloAltoFieldType.LONG));
        fields.add(PaloAltoFieldTemplate.create("pan_dev_group_level_4", 50, PaloAltoFieldType.LONG));
        fields.add(PaloAltoFieldTemplate.create("host_virtfw_hostname", 51, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("event_observer_hostname", 52, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("vendor_event_description", 53, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("source_vsys_uuid", 54, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("destination_vsys_uuid", 55, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("pan_tunnel_id", 56, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("pan_monitor_tag", 57, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("pan_parent_session_id", 58, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("pan_parent_start_time", 59, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("network_tunnel_type", 60, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("pan_assoc_id", 61, PaloAltoFieldType.LONG));
        fields.add(PaloAltoFieldTemplate.create("pan_sctp_chunks_sum", 62, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("pan_sctp_chunks_tx", 63, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("pan_sctp_chunks_rx", 64, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("policy_uid", 65, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("pan_http2", 66, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("pan_link_changes", 67, PaloAltoFieldType.LONG));
        fields.add(PaloAltoFieldTemplate.create("pan_sdwan_policyid", 68, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("pan_link_switches", 69, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("pan_sdwan_cluster", 70, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("pan_sdwan_device_type", 71, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("pan_sdwan_cluster_type", 72, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("pan_sdwan_site_name", 73, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("pan_dynusergroup_name", 74, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("http_xff", 75, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("source_category", 76, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("pan_source_profile", 77, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("source_device_model", 78, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("source_device_vendor", 79, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("source_os_name", 80, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("source_os_version", 81, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("source_hostname", 82, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("source_mac", 83, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("destination_category", 84, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("pan_destination_profile", 85, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("destination_device_model", 86, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("destination_device_vendor", 87, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("destination_os_name", 88, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("destination_os_version", 89, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("destination_hostname", 90, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("destination_mac", 91, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("container_id", 92, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("container_namespace", 93, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("container_name", 94, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("pan_src_edl", 95, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("pan_dst_edl", 96, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("pan_host_id", 97, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("pan_host_sn", 98, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("pan_src_dag", 99, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("pan_dst_dag", 100, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("pan_session_owner", 101, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("pan_high_res_time", 102, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("pan_nsdsai_sst", 103, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("pan_nsdsai_sd", 104, PaloAltoFieldType.STRING));
        return PaloAlto9xTemplates.toTemplate(fields);
    }

    public static PaloAltoMessageTemplate userIdTemplate() {
        TreeSet fields = Sets.newTreeSet();
        fields.add(PaloAltoFieldTemplate.create("event_created", 1, PaloAltoFieldType.TIMESTAMP));
        fields.add(PaloAltoFieldTemplate.create("event_observer_uid", 2, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("event_log_name", 3, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("pan_log_subtype", 4, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("timestamp", 6, PaloAltoFieldType.TIMESTAMP));
        fields.add(PaloAltoFieldTemplate.create("host_virtfw_id", 7, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("source_ip", 8, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("source_user", 9, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("pan_datasource_name", 10, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("pan_event_name", 11, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("event_repeat_count", 12, PaloAltoFieldType.LONG));
        fields.add(PaloAltoFieldTemplate.create("pan_timeout", 13, PaloAltoFieldType.LONG));
        fields.add(PaloAltoFieldTemplate.create("source_port", 14, PaloAltoFieldType.LONG));
        fields.add(PaloAltoFieldTemplate.create("destination_port", 15, PaloAltoFieldType.LONG));
        fields.add(PaloAltoFieldTemplate.create("pan_datasource", 16, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("pan_datasource_type", 17, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("event_uid", 18, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("pan_log_panorama", 19, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("pan_dev_group_level_1", 20, PaloAltoFieldType.LONG));
        fields.add(PaloAltoFieldTemplate.create("pan_dev_group_level_2", 21, PaloAltoFieldType.LONG));
        fields.add(PaloAltoFieldTemplate.create("pan_dev_group_level_3", 22, PaloAltoFieldType.LONG));
        fields.add(PaloAltoFieldTemplate.create("pan_dev_group_level_4", 23, PaloAltoFieldType.LONG));
        fields.add(PaloAltoFieldTemplate.create("host_virtfw_hostname", 24, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("event_observer_hostname", 25, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("host_virtfw_uid", 26, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("pan_factor_type", 27, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("pan_factor_completion_time", 28, PaloAltoFieldType.TIMESTAMP));
        fields.add(PaloAltoFieldTemplate.create("pan_factor_number", 29, PaloAltoFieldType.LONG));
        fields.add(PaloAltoFieldTemplate.create("pan_user_group_flags", 32, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("pan_source_user", 33, PaloAltoFieldType.STRING));
        fields.add(PaloAltoFieldTemplate.create("pan_high_res_time", 34, PaloAltoFieldType.STRING));
        return PaloAlto9xTemplates.toTemplate(fields);
    }
}

