/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.beats;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.io.ByteStreams;
import com.google.common.primitives.Ints;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ReplayingDecoder;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.zip.InflaterInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BeatsFrameDecoder
extends ReplayingDecoder<DecodingState> {
    private static final Logger LOG = LoggerFactory.getLogger(BeatsFrameDecoder.class);
    private static final byte PROTOCOL_VERSION = 50;
    private static final byte FRAME_ACK = 65;
    private static final byte FRAME_COMPRESSED = 67;
    private static final byte FRAME_DATA = 68;
    private static final byte FRAME_JSON = 74;
    private static final byte FRAME_WINDOW_SIZE = 87;
    private long windowSize;
    private long sequenceNum;

    public BeatsFrameDecoder() {
        super((Object)DecodingState.PROTOCOL_VERSION);
    }

    protected void decode(ChannelHandlerContext channelHandlerContext, ByteBuf buffer, List<Object> list) throws Exception {
        switch ((DecodingState)((Object)this.state())) {
            case PROTOCOL_VERSION: {
                this.checkVersion(buffer);
                this.checkpoint((Object)DecodingState.FRAME_TYPE);
            }
            case FRAME_TYPE: {
                byte frameType = buffer.readByte();
                switch (frameType) {
                    case 87: {
                        this.checkpoint((Object)DecodingState.FRAME_WINDOW_SIZE);
                        break;
                    }
                    case 68: {
                        this.checkpoint((Object)DecodingState.FRAME_DATA);
                        break;
                    }
                    case 67: {
                        this.checkpoint((Object)DecodingState.FRAME_COMPRESSED);
                        break;
                    }
                    case 74: {
                        this.checkpoint((Object)DecodingState.FRAME_JSON);
                        break;
                    }
                    default: {
                        throw new Exception("Unknown frame type: " + frameType);
                    }
                }
                return;
            }
            case FRAME_WINDOW_SIZE: {
                this.processWindowSizeFrame(buffer);
                break;
            }
            case FRAME_DATA: {
                list.addAll(this.parseDataFrame(channelHandlerContext.channel(), buffer));
                break;
            }
            case FRAME_COMPRESSED: {
                list.addAll(this.processCompressedFrame(channelHandlerContext.channel(), buffer));
                break;
            }
            case FRAME_JSON: {
                list.addAll(this.parseJsonFrame(channelHandlerContext.channel(), buffer));
                break;
            }
            default: {
                throw new Exception("Unknown decoding state: " + this.state());
            }
        }
        this.checkpoint((Object)DecodingState.PROTOCOL_VERSION);
    }

    private Collection<ByteBuf> processUncompressedBuffer(Channel channel, ByteBuf buffer) throws Exception {
        this.checkVersion(buffer);
        byte frameType = buffer.readByte();
        switch (frameType) {
            case 87: {
                this.processWindowSizeFrame(buffer);
                return Collections.emptyList();
            }
            case 68: {
                return this.parseDataFrame(channel, buffer);
            }
            case 67: {
                return this.processCompressedFrame(channel, buffer);
            }
            case 74: {
                return this.parseJsonFrame(channel, buffer);
            }
        }
        throw new Exception("Unknown frame type: " + frameType);
    }

    private void checkVersion(ByteBuf channelBuffer) {
        byte version = channelBuffer.readByte();
        if (version != 50) {
            throw new IllegalStateException("Unknown beats protocol version: " + version);
        }
    }

    private void sendACK(Channel channel) throws IOException {
        if (this.sequenceNum == this.windowSize) {
            ByteBuf buffer = channel.alloc().buffer(6);
            buffer.writeByte(50);
            buffer.writeByte(65);
            buffer.writeInt((int)this.sequenceNum);
            LOG.trace("Sending ACK for sequence number {} on channel {}", (Object)this.sequenceNum, (Object)channel);
            channel.writeAndFlush((Object)buffer);
        }
    }

    private Collection<ByteBuf> parseJsonFrame(Channel channel, ByteBuf channelBuffer) throws IOException {
        this.sequenceNum = channelBuffer.readUnsignedInt();
        LOG.trace("Received sequence number {}", (Object)this.sequenceNum);
        int jsonLength = Ints.saturatedCast((long)channelBuffer.readUnsignedInt());
        ByteBuf buffer = channelBuffer.readBytes(jsonLength);
        this.sendACK(channel);
        return Collections.singleton(buffer);
    }

    private Collection<ByteBuf> processCompressedFrame(Channel channel, ByteBuf channelBuffer) throws Exception {
        long payloadLength = channelBuffer.readUnsignedInt();
        byte[] data = new byte[(int)payloadLength];
        channelBuffer.readBytes(data);
        try (ByteArrayInputStream dataStream = new ByteArrayInputStream(data);){
            Collection<ByteBuf> collection;
            try (InflaterInputStream in = new InflaterInputStream(dataStream);){
                ByteBuf buffer = Unpooled.wrappedBuffer((byte[])ByteStreams.toByteArray((InputStream)in));
                collection = this.processCompressedDataFrames(channel, buffer);
            }
            return collection;
        }
    }

    private Collection<ByteBuf> processCompressedDataFrames(Channel channel, ByteBuf channelBuffer) throws Exception {
        ArrayList<ByteBuf> events = new ArrayList<ByteBuf>();
        while (channelBuffer.isReadable()) {
            Collection<ByteBuf> buffers = this.processUncompressedBuffer(channel, channelBuffer);
            events.addAll(buffers);
        }
        return events;
    }

    private void processWindowSizeFrame(ByteBuf channelBuffer) {
        this.windowSize = channelBuffer.readUnsignedInt();
        LOG.trace("Changed window size to {}", (Object)this.windowSize);
    }

    private Collection<ByteBuf> parseDataFrame(Channel channel, ByteBuf channelBuffer) throws IOException {
        this.sequenceNum = channelBuffer.readUnsignedInt();
        LOG.trace("Received sequence number {}", (Object)this.sequenceNum);
        int pairs = Ints.saturatedCast((long)channelBuffer.readUnsignedInt());
        JsonFactory jsonFactory = new JsonFactory();
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try (JsonGenerator jg = jsonFactory.createGenerator((OutputStream)outputStream);){
            jg.writeStartObject();
            for (int i = 0; i < pairs; ++i) {
                String key = this.parseDataItem(channelBuffer);
                String value = this.parseDataItem(channelBuffer);
                jg.writeStringField(key, value);
            }
            jg.writeEndObject();
        }
        ByteBuf buffer = Unpooled.wrappedBuffer((byte[])outputStream.toByteArray());
        this.sendACK(channel);
        return Collections.singleton(buffer);
    }

    private String parseDataItem(ByteBuf buf) {
        int length = Ints.saturatedCast((long)buf.readUnsignedInt());
        ByteBuf item = buf.readSlice(length);
        return item.toString(StandardCharsets.UTF_8);
    }

    @VisibleForTesting
    long getWindowSize() {
        return this.windowSize;
    }

    @VisibleForTesting
    long getSequenceNum() {
        return this.sequenceNum;
    }

    static enum DecodingState {
        PROTOCOL_VERSION,
        FRAME_TYPE,
        FRAME_COMPRESSED,
        FRAME_DATA,
        FRAME_JSON,
        FRAME_WINDOW_SIZE;

    }
}

