/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.pipelineprocessor.functions;

import com.google.common.collect.ImmutableList;
import com.swrve.ratelimitedlogger.RateLimitedLog;
import jakarta.inject.Inject;
import org.graylog.plugins.pipelineprocessor.EvaluationContext;
import org.graylog.plugins.pipelineprocessor.ast.functions.AbstractFunction;
import org.graylog.plugins.pipelineprocessor.ast.functions.FunctionArgs;
import org.graylog.plugins.pipelineprocessor.ast.functions.FunctionDescriptor;
import org.graylog.plugins.pipelineprocessor.ast.functions.ParameterDescriptor;
import org.graylog.plugins.pipelineprocessor.processors.PipelineInterpreter;
import org.graylog.plugins.pipelineprocessor.rulebuilder.RuleBuilderFunctionGroup;
import org.graylog2.grok.GrokPatternRegistry;

public class GrokExists
extends AbstractFunction<Boolean> {
    private static final RateLimitedLog log = PipelineInterpreter.getRateLimitedLog(GrokExists.class);
    public static final String NAME = "grok_exists";
    private final ParameterDescriptor<String, String> patternParam;
    private final ParameterDescriptor<Boolean, Boolean> doLog;
    private final GrokPatternRegistry grokPatternRegistry;

    @Inject
    public GrokExists(GrokPatternRegistry grokPatternRegistry) {
        this.grokPatternRegistry = grokPatternRegistry;
        this.patternParam = ParameterDescriptor.string("pattern").description("The Grok Pattern which is to be tested for existence.").build();
        this.doLog = ParameterDescriptor.bool("log_missing").optional().description("Log if the Grok Pattern is missing. Warning: Switching on this flag can lead to a high volume of logs.").build();
    }

    @Override
    public Boolean evaluate(FunctionArgs args, EvaluationContext context) {
        String pattern = this.patternParam.required(args, context);
        boolean logWhenNotFound = this.doLog.optional(args, context).orElse(false);
        if (pattern == null) {
            return null;
        }
        boolean patternExists = this.grokPatternRegistry.grokPatternExists(pattern);
        if (!patternExists && logWhenNotFound) {
            log.info(context.pipelineErrorMessage("Grok Pattern " + pattern + " does not exist."));
        }
        return patternExists;
    }

    @Override
    public FunctionDescriptor<Boolean> descriptor() {
        return FunctionDescriptor.builder().name(NAME).returnType(Boolean.class).params((ImmutableList<ParameterDescriptor>)ImmutableList.of(this.patternParam, this.doLog)).description("Checks if the given Grok pattern exists in Graylog.").ruleBuilderEnabled().ruleBuilderName("Check for grok pattern").ruleBuilderTitle("Check if grok pattern named '${pattern}' exists in Graylog").ruleBuilderFunctionGroup(RuleBuilderFunctionGroup.PATTERN).build();
    }
}

