/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.pipelineprocessor.functions.messages;

import com.google.common.collect.ImmutableList;
import org.graylog.plugins.pipelineprocessor.EvaluationContext;
import org.graylog.plugins.pipelineprocessor.ast.functions.AbstractFunction;
import org.graylog.plugins.pipelineprocessor.ast.functions.FunctionArgs;
import org.graylog.plugins.pipelineprocessor.ast.functions.FunctionDescriptor;
import org.graylog.plugins.pipelineprocessor.ast.functions.ParameterDescriptor;
import org.graylog.plugins.pipelineprocessor.rulebuilder.RuleBuilderFunctionGroup;
import org.graylog2.plugin.Message;

public class HasField
extends AbstractFunction<Boolean> {
    public static final String NAME = "has_field";
    public static final String FIELD = "field";
    private final ParameterDescriptor<String, String> fieldParam = ParameterDescriptor.string("field").description("The field to check").build();
    private final ParameterDescriptor<Message, Message> messageParam = ParameterDescriptor.type("message", Message.class).optional().description("The message to use, defaults to '$message'").ruleBuilderVariable().build();

    @Override
    public Boolean evaluate(FunctionArgs args, EvaluationContext context) {
        String field = this.fieldParam.required(args, context);
        Message message = this.messageParam.optional(args, context).orElse(context.currentMessage());
        return message.hasField(field);
    }

    @Override
    public FunctionDescriptor<Boolean> descriptor() {
        return FunctionDescriptor.builder().name(NAME).returnType(Boolean.class).params((ImmutableList<ParameterDescriptor>)ImmutableList.of(this.fieldParam, this.messageParam)).description("Checks whether a message contains a value for a field").ruleBuilderEnabled().ruleBuilderName("Has field").ruleBuilderTitle("Message has field '${field}'").ruleBuilderFunctionGroup(RuleBuilderFunctionGroup.MESSAGE).build();
    }
}

