/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.sidecar.migrations;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.auto.value.AutoValue;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.model.Filters;
import com.mongodb.client.result.UpdateResult;
import jakarta.inject.Inject;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.time.ZonedDateTime;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.zip.CRC32;
import javax.annotation.Nullable;
import org.bson.Document;
import org.bson.types.ObjectId;
import org.graylog.plugins.sidecar.migrations.AutoValue_V20180212165000_AddDefaultCollectors_MigrationState;
import org.graylog.plugins.sidecar.rest.models.Collector;
import org.graylog.plugins.sidecar.rest.models.Configuration;
import org.graylog.plugins.sidecar.rest.models.ConfigurationVariable;
import org.graylog.plugins.sidecar.services.CollectorService;
import org.graylog.plugins.sidecar.services.ConfigurationService;
import org.graylog.plugins.sidecar.services.ConfigurationVariableService;
import org.graylog2.configuration.HttpConfiguration;
import org.graylog2.database.MongoConnection;
import org.graylog2.migrations.Migration;
import org.graylog2.plugin.cluster.ClusterConfigService;
import org.graylog2.shared.utilities.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class V20180212165000_AddDefaultCollectors
extends Migration {
    public static final String BEATS_PREAMBEL = "# Needed for Graylog\nfields_under_root: true\nfields.collector_node_id: ${sidecar.nodeName}\nfields.gl2_source_collector: ${sidecar.nodeId}\n\n";
    public static final String OS_FREEBSD = "freebsd";
    public static final String OS_LINUX = "linux";
    public static final String OS_DARWIN = "darwin";
    public static final String OS_WINDOWS = "windows";
    private static final Logger LOG = LoggerFactory.getLogger(V20180212165000_AddDefaultCollectors.class);
    private final CollectorService collectorService;
    private final ConfigurationVariableService configurationVariableService;
    private final MongoCollection<Document> collection;
    private final URI httpExternalUri;
    private final ConfigurationService configurationService;
    private final ClusterConfigService clusterConfigService;
    private MigrationState migrationState;
    private MigrationState updatedMigrationState;

    @Inject
    public V20180212165000_AddDefaultCollectors(HttpConfiguration httpConfiguration, CollectorService collectorService, ConfigurationVariableService configurationVariableService, ConfigurationService configurationService, MongoConnection mongoConnection, ClusterConfigService clusterConfigService) {
        this.httpExternalUri = httpConfiguration.getHttpExternalUri();
        this.collectorService = collectorService;
        this.configurationVariableService = configurationVariableService;
        this.configurationService = configurationService;
        this.collection = mongoConnection.getMongoDatabase().getCollection("sidecar_collectors");
        this.clusterConfigService = clusterConfigService;
    }

    @Override
    public ZonedDateTime createdAt() {
        return ZonedDateTime.parse("2018-02-12T16:50:00Z");
    }

    @Override
    public void upgrade() {
        this.updatedMigrationState = this.migrationState = this.clusterConfigService.getOrDefault(MigrationState.class, MigrationState.createEmpty());
        this.removeConfigPath();
        this.ensureConfigurationVariable("graylog_host", "Graylog Host.", this.httpExternalUri.getHost());
        this.ensureFilebeatCollectorsAndConfig();
        this.ensureAuditbeatCollectorsAndConfig();
        this.ensureWinlogbeatCollectorsAndConfig();
        this.ensureNxLogCollectors();
        if (!this.updatedMigrationState.equals(this.migrationState)) {
            this.clusterConfigService.write(this.updatedMigrationState);
        }
    }

    private void ensureFilebeatCollectorsAndConfig() {
        StringBuilder filebeatConfigBuilder = new StringBuilder(StringUtils.f("%s\noutput.logstash:\n   hosts: [\"${user.graylog_host}:5044\"]\npath:\n   data: ${sidecar.spoolDir!\"/var/lib/graylog-sidecar/collectors/filebeat\"}/data\n   logs: ${sidecar.spoolDir!\"/var/lib/graylog-sidecar/collectors/filebeat\"}/log\n\nfilebeat.inputs:\n", BEATS_PREAMBEL));
        String apacheConfigType = "- type: filestream\n  id: apache-filestream\n  enabled: true\n  %s\n  fields_under_root: true\n  fields:\n      event_source_product: apache_httpd";
        this.ensureCollector("filebeat", "exec", OS_LINUX, "/usr/lib/graylog-sidecar/filebeat", "-c  %s", "test config -c %s", filebeatConfigBuilder.append("\n- type: filestream\n  id: snort-filestream\n  enabled: true\n  paths:\n    - /var/log/snort/alert_json.txt\n    - /var/log/snort/appid-output.json\n  parsers:\n    - ndjson:\n        target: \"snort3\"\n        add_error_key: true\n        overwrite_keys: true\n  fields:\n    event_source_product: snort3\n").append("\n- type: filestream\n  id: zeek-filestream\n  enabled: true\n  paths:\n    - /opt/zeek/logs/current\n  parsers:\n    - ndjson:\n        target: \"zeek\"\n        add_error_key: true\n        overwrite_keys: true\n  fields:\n    event_source_product: zeek\n").append(StringUtils.f(apacheConfigType, "paths:\n  - /var/log/apache2/access.log\n  - /var/log/apache2/error.log\n  - /var/log/httpd/access_log\n  - /var/log/httpd/error_log\n")).toString()).ifPresent(collector -> this.ensureDefaultConfiguration("filebeat-linux-default", (Collector)collector));
        this.ensureCollector("filebeat", "exec", OS_FREEBSD, "/usr/share/filebeat/bin/filebeat", "-c  %s", "test config -c %s", filebeatConfigBuilder.append(StringUtils.f(apacheConfigType, "paths:\n  - /var/log/httpd-access.log\n  - /var/log/httpd-error.log\n")).toString()).ifPresent(collector -> this.ensureDefaultConfiguration("filebeat-freebsd-default", (Collector)collector));
        this.ensureCollector("filebeat", "exec", OS_DARWIN, "/usr/share/filebeat/bin/filebeat", "-c  %s", "test config -c %s", filebeatConfigBuilder.append(StringUtils.f(apacheConfigType, "paths:\n  - /etc/httpd/log/access_log\n  - /etc/httpd/log/error_log\n")).toString()).ifPresent(collector -> this.ensureDefaultConfiguration("filebeat-darwin-default", (Collector)collector));
        this.ensureCollector("filebeat", "svc", OS_WINDOWS, "C:\\Program Files\\Graylog\\sidecar\\filebeat.exe", "-c \"%s\"", "test config -c \"%s\"", StringUtils.f("%s\noutput.logstash:\n   hosts: [\"${user.graylog_host}:5044\"]\npath:\n   data: ${sidecar.spoolDir!\"C:\\\\Program Files\\\\Graylog\\\\sidecar\\\\cache\\\\filebeat\"}\\data\n   logs: ${sidecar.spoolDir!\"C:\\\\Program Files\\\\Graylog\\\\sidecar\"}\\logs\ntags:\n- windows\nfilebeat.inputs:\n- type: log\n  enabled: true\n  paths:\n  - C:\\logs\\log.log\n", BEATS_PREAMBEL));
    }

    private void ensureAuditbeatCollectorsAndConfig() {
        this.ensureCollector("auditbeat", "exec", OS_LINUX, "/usr/lib/graylog-sidecar/auditbeat", "-c  %s", "test config -c %s", StringUtils.f("%s\noutput.logstash:\n   hosts: [\"${user.graylog_host}:5044\"]\npath:\n   data: ${sidecar.spoolDir!\"/var/lib/graylog-sidecar/collectors/auditbeat\"}/data\n   logs: ${sidecar.spoolDir!\"/var/lib/graylog-sidecar/collectors/auditbeat\"}/log\nfields:\n  event_source_product: linux_auditbeat\n\n# You can find the full configuration reference here:\n# https://www.elastic.co/guide/en/beats/auditbeat/index.html\n\n# =========================== Modules configuration ============================\nauditbeat.modules:\n\n# The auditd module collects events from the audit framework in the Linux kernel.\n- module: auditd\n  resolve_ids: true\n  failure_mode: log\n  backlog_limit: 8196\n  rate_limit: 0\n  include_raw_message: true\n  include_warnings: true\n  backpressure_strategy: auto\n\n  audit_rules: |\n    ## Define audit rules here.\n    ## Create file watches (-w) or syscall audits (-a or -A).\n\n    ## If you are on a 64 bit platform, everything should be running\n    ## in 64 bit mode. This rule will detect any use of the 32 bit syscalls\n    ## because this might be a sign of someone exploiting a hole in the 32\n    ## bit API.\n    -a always,exit -F arch=b32 -S all -F key=32bit-abi\n\n    ## Executions.\n    -a always,exit -F arch=b64 -S execve,execveat -k exec\n\n    ## External access (warning: these can be expensive to audit).\n    -a always,exit -F arch=b64 -S accept,bind,connect -F key=external-access\n\n    ## Identity changes.\n    -w /etc/group -p wa -k identity\n    -w /etc/passwd -p wa -k identity\n    -w /etc/gshadow -p wa -k identity\n    -w /etc/shadow -p wa -k identity\n\n    ## Unauthorized access attempts.\n    -a always,exit -F arch=b32 -S open,creat,truncate,ftruncate,openat,open_by_handle_at -F exit=-EACCES -F auid>=1000 -F auid!=4294967295 -F key=access\n    -a always,exit -F arch=b32 -S open,creat,truncate,ftruncate,openat,open_by_handle_at -F exit=-EPERM -F auid>=1000 -F auid!=4294967295 -F key=access\n    -a always,exit -F arch=b64 -S open,creat,truncate,ftruncate,openat,open_by_handle_at -F exit=-EACCES -F auid>=1000 -F auid!=4294967295 -F key=access\n    -a always,exit -F arch=b64 -S open,creat,truncate,ftruncate,openat,open_by_handle_at -F exit=-EPERM -F auid>=1000 -F auid!=4294967295 -F key=access\n\n# The file integrity module sends events when files are changed (created, updated, deleted).\n# The events contain file metadata and hashes.\n- module: file_integrity\n  paths:\n  - /bin\n  - /usr/bin\n  - /sbin\n  - /usr/sbin\n  - /etc\n  - /etc/graylog/server\n  exclude_files:\n  - '(?i)\\.sw[nop]$'\n  - '~$'\n  - '/\\.git($|/)'\n  include_files: []\n  scan_at_start: true\n  scan_rate_per_sec: 50 MiB\n  max_file_size: 100 MiB\n  hash_types: [sha256]\n  recursive: false", BEATS_PREAMBEL)).ifPresent(collector -> this.ensureDefaultConfiguration("auditbeat-linux-default", (Collector)collector));
    }

    private void ensureWinlogbeatCollectorsAndConfig() {
        this.ensureCollector("winlogbeat", "svc", OS_WINDOWS, "C:\\Program Files\\Graylog\\sidecar\\winlogbeat.exe", "-c \"%s\"", "test config -c \"%s\"", StringUtils.f("%s\noutput.logstash:\n   hosts: [\"${user.graylog_host}:5044\"]\npath:\n  data: ${sidecar.spoolDir!\"C:\\\\Program Files\\\\Graylog\\\\sidecar\\\\cache\\\\winlogbeat\"}\\data\n  logs: ${sidecar.spoolDir!\"C:\\\\Program Files\\\\Graylog\\\\sidecar\"}\\logs\ntags:\n - windows\nwinlogbeat:\n  event_logs:\n   - name: Application\n     ignore_older: 96h\n   - name: System\n     ignore_older: 96h\n   - name: Security\n     ignore_older: 96h\n   - name: Setup\n     ignore_older: 96h\n   - name: ForwardedEvents\n     forwarded: true\n     ignore_older: 96h\n   - name: Microsoft-Windows-Windows Defender/Operational\n     ignore_older: 96h\n   - name: Microsoft-Windows-Sysmon/Operational\n     ignore_older: 96h\n   - name: Microsoft-Windows-TerminalServices-LocalSessionManager/Operational\n     ignore_older: 96h\n   - name: Microsoft-Windows-PowerShell/Operational\n     ignore_older: 96h\n   - name: windows PowerShell\n     ignore_older: 96h", BEATS_PREAMBEL)).ifPresent(collector -> this.ensureDefaultConfiguration("winlogbeat-default", (Collector)collector));
    }

    private void ensureNxLogCollectors() {
        this.ensureCollector("nxlog", "exec", OS_LINUX, "/usr/bin/nxlog", "-f -c %s", "-v -c %s", "define ROOT /usr/bin\n\n<Extension gelfExt>\n  Module xm_gelf\n  # Avoid truncation of the short_message field to 64 characters.\n  ShortMessageLength 65536\n</Extension>\n\n<Extension syslogExt>\n  Module xm_syslog\n</Extension>\n\nUser nxlog\nGroup nxlog\n\nModuledir /usr/lib/nxlog/modules\nCacheDir ${sidecar.spoolDir!\"/var/spool/nxlog\"}/data\nPidFile ${sidecar.spoolDir!\"/var/run/nxlog\"}/nxlog.pid\nLogFile ${sidecar.spoolDir!\"/var/log/nxlog\"}/nxlog.log\nLogLevel INFO\n\n\n<Input file>\n\tModule im_file\n\tFile '/var/log/*.log'\n\tPollInterval 1\n\tSavePos\tTrue\n\tReadFromLast True\n\tRecursive False\n\tRenameCheck False\n\tExec $FileName = file_name(); # Send file name with each message\n</Input>\n\n#<Input syslog-udp>\n#\tModule im_udp\n#\tHost 127.0.0.1\n#\tPort 514\n#\tExec parse_syslog_bsd();\n#</Input>\n\n<Output gelf>\n\tModule om_tcp\n\tHost ${user.graylog_host}\n\tPort 12201\n\tOutputType  GELF_TCP\n\t<Exec>\n\t  # These fields are needed for Graylog\n\t  $gl2_source_collector = '${sidecar.nodeId}';\n\t  $collector_node_id = '${sidecar.nodeName}';\n\t</Exec>\n</Output>\n\n\n<Route route-1>\n  Path file => gelf\n</Route>\n#<Route route-2>\n#  Path syslog-udp => gelf\n#</Route>\n\n\n");
        this.ensureCollector("nxlog", "svc", OS_WINDOWS, "C:\\Program Files (x86)\\nxlog\\nxlog.exe", "-c \"%s\"", "-v -f -c \"%s\"", "define ROOT ${sidecar.spoolDir!\"C:\\\\Program Files (x86)\"}\\nxlog\n\nModuledir %ROOT%\\modules\nCacheDir %ROOT%\\data\nPidfile %ROOT%\\data\\nxlog.pid\nSpoolDir %ROOT%\\data\nLogFile %ROOT%\\data\\nxlog.log\nLogLevel INFO\n\n<Extension logrotate>\n    Module  xm_fileop\n    <Schedule>\n        When    @daily\n        Exec    file_cycle('%ROOT%\\data\\nxlog.log', 7);\n     </Schedule>\n</Extension>\n\n\n<Extension gelfExt>\n  Module xm_gelf\n  # Avoid truncation of the short_message field to 64 characters.\n  ShortMessageLength 65536\n</Extension>\n\n<Input eventlog>\n        Module im_msvistalog\n        PollInterval 1\n        SavePos True\n        ReadFromLast True\n        \n        #Channel System\n        #<QueryXML>\n        #  <QueryList>\n        #   <Query Id='1'>\n        #    <Select Path='Security'>*[System/Level=4]</Select>\n        #    </Query>\n        #  </QueryList>\n        #</QueryXML>\n</Input>\n\n\n<Input file>\n\tModule im_file\n\tFile 'C:\\Windows\\MyLogDir\\\\*.log'\n\tPollInterval 1\n\tSavePos\tTrue\n\tReadFromLast True\n\tRecursive False\n\tRenameCheck False\n\tExec $FileName = file_name(); # Send file name with each message\n</Input>\n\n\n<Output gelf>\n\tModule om_tcp\n\tHost ${user.graylog_host}\n\tPort 12201\n\tOutputType  GELF_TCP\n\t<Exec>\n\t  # These fields are needed for Graylog\n\t  $gl2_source_collector = '${sidecar.nodeId}';\n\t  $collector_node_id = '${sidecar.nodeName}';\n\t</Exec>\n</Output>\n\n\n<Route route-1>\n  Path eventlog => gelf\n</Route>\n<Route route-2>\n  Path file => gelf\n</Route>\n\n");
    }

    private void removeConfigPath() {
        FindIterable documentsWithConfigPath = this.collection.find(Filters.exists((String)"configuration_path"));
        for (Document document : documentsWithConfigPath) {
            ObjectId objectId = document.getObjectId((Object)"_id");
            document.remove((Object)"configuration_path");
            UpdateResult updateResult = this.collection.replaceOne(Filters.eq((String)"_id", (Object)objectId), (Object)document);
            if (updateResult.wasAcknowledged()) {
                LOG.debug("Successfully updated document with ID <{}>", (Object)objectId);
                continue;
            }
            LOG.error("Failed to update document with ID <{}>", (Object)objectId);
        }
    }

    private Optional<Collector> ensureCollector(String collectorName, String serviceType, String nodeOperatingSystem, String executablePath, String executeParameters, String validationCommand, String defaultTemplate) {
        this.updatedMigrationState = this.updatedMigrationState.withNewDefaultTemplate(collectorName, nodeOperatingSystem, defaultTemplate);
        Collector collector = null;
        try {
            collector = this.collectorService.findByNameAndOs(collectorName, nodeOperatingSystem);
            if (collector == null) {
                String msg = "Couldn't find collector '{} on {}' fixing it.";
                LOG.debug("Couldn't find collector '{} on {}' fixing it.", (Object)collectorName, (Object)nodeOperatingSystem);
                throw new IllegalArgumentException();
            }
            if (!defaultTemplate.equals(collector.defaultTemplate()) && this.migrationState.isKnownDefaultTemplate(collectorName, nodeOperatingSystem, collector.defaultTemplate())) {
                LOG.info("{} collector default template on {} is unchanged, updating it.", (Object)collectorName, (Object)nodeOperatingSystem);
                try {
                    return Optional.of(this.collectorService.save(collector.toBuilder().defaultTemplate(defaultTemplate).build()));
                }
                catch (Exception e) {
                    LOG.error("Can't save collector '{}'!", (Object)collectorName, (Object)e);
                }
            }
        }
        catch (IllegalArgumentException ignored) {
            LOG.info("{} collector on {} is missing, adding it.", (Object)collectorName, (Object)nodeOperatingSystem);
            try {
                return Optional.of(this.collectorService.save(Collector.create(null, collectorName, serviceType, nodeOperatingSystem, executablePath, executeParameters, validationCommand, defaultTemplate)));
            }
            catch (Exception e) {
                LOG.error("Can't save collector '{}'!", (Object)collectorName, (Object)e);
            }
        }
        if (collector == null) {
            LOG.error("Unable to access fixed '{}' collector!", (Object)collectorName);
            return Optional.empty();
        }
        return Optional.of(collector);
    }

    private void ensureConfigurationVariable(String name, String description, String content) {
        ConfigurationVariable variable = null;
        try {
            variable = this.configurationVariableService.findByName(name);
            if (variable == null) {
                LOG.debug("Couldn't find sidecar configuration variable '{}' fixing it.", (Object)name);
                throw new IllegalArgumentException();
            }
        }
        catch (IllegalArgumentException ignored) {
            LOG.info("'{}' sidecar configuration variable is missing, adding it.", (Object)name);
            try {
                variable = this.configurationVariableService.save(ConfigurationVariable.create(name, description, content));
            }
            catch (Exception e) {
                LOG.error("Can't save sidecar configuration variable '{}'!", (Object)name, (Object)e);
            }
        }
        if (variable == null) {
            LOG.error("Unable to access '{}' sidecar configuration variable!", (Object)name);
        }
    }

    private void ensureDefaultConfiguration(String name, Collector collector) {
        Configuration config = null;
        try {
            config = this.configurationService.findByName(name);
            if (config == null) {
                LOG.debug("Couldn't find sidecar default configuration'{}' fixing it.", (Object)name);
                throw new IllegalArgumentException();
            }
            if (!config.template().equals(collector.defaultTemplate()) && this.migrationState.isKnownDefaultTemplate(collector.name(), collector.nodeOperatingSystem(), config.template())) {
                LOG.info("Sidecar configuration '{}' still matches a known default. Updating.", (Object)name);
                this.configurationService.save(config.toBuilder().template(collector.defaultTemplate()).build());
            }
        }
        catch (IllegalArgumentException ignored) {
            LOG.info("'{}' sidecar default configuration is missing, adding it.", (Object)name);
            try {
                config = this.configurationService.save(Configuration.createWithoutId(collector.id(), name, "#ffffff", collector.defaultTemplate(), Set.of("default")));
            }
            catch (Exception e) {
                LOG.error("Can't save sidecar default configuration '{}'!", (Object)name, (Object)e);
            }
        }
        if (config == null) {
            LOG.error("Unable to access '{}' sidecar default configuration!", (Object)name);
        }
    }

    @JsonAutoDetect
    @AutoValue
    public static abstract class MigrationState {
        private static final Set<CollectorChecksum> OLD_CHECKSUMS = Set.of(new CollectorChecksum("filebeat", "linux", 3280545580L), new CollectorChecksum("filebeat", "darwin", 3396210381L), new CollectorChecksum("filebeat", "freebsd", 3013497446L), new CollectorChecksum("winlogbeat", "windows", 4009863009L), new CollectorChecksum("nxlog", "linux", 2023247173L), new CollectorChecksum("nxlog", "windows", 2491201449L), new CollectorChecksum("auditbeat", "windows", 2487909285L), new CollectorChecksum("filebeat", "linux", 4049210961L), new CollectorChecksum("filebeat", "darwin", 4049210961L), new CollectorChecksum("filebeat", "freebsd", 4049210961L), new CollectorChecksum("winlogbeat", "windows", 2306685777L), new CollectorChecksum("nxlog", "linux", 639836274L), new CollectorChecksum("nxlog", "windows", 2157898695L), new CollectorChecksum("filebeat", "linux", 1256873081L), new CollectorChecksum("winlogbeat", "windows", 3852098581L), new CollectorChecksum("nxlog", "linux", 3676599312L), new CollectorChecksum("nxlog", "windows", 4293222217L));
        private static final Set<CollectorChecksum> OLD_FILEBEAT_WINDOWS = Set.of(new CollectorChecksum("filebeat", "windows", 1490581247L), new CollectorChecksum("filebeat", "windows", 3884777971L), new CollectorChecksum("filebeat", "windows", 341507103L), new CollectorChecksum("filebeat", "windows", 1931248542L), new CollectorChecksum("filebeat", "windows", 2559816928L));

        @JsonProperty(value="knownChecksums")
        public abstract Set<CollectorChecksum> knownChecksums();

        public static MigrationState createEmpty() {
            return MigrationState.create(Set.of());
        }

        public MigrationState withNewDefaultTemplate(String collectorName, String platform, String template) {
            Set<CollectorChecksum> merged = this.knownChecksums();
            merged.add(MigrationState.checksum(collectorName, platform, template));
            return MigrationState.create(merged);
        }

        @JsonCreator
        public static MigrationState create(@JsonProperty(value="knownChecksums") Set<CollectorChecksum> knownChecksums) {
            HashSet<CollectorChecksum> merged = new HashSet<CollectorChecksum>(knownChecksums);
            merged.addAll(OLD_CHECKSUMS);
            merged.addAll(OLD_FILEBEAT_WINDOWS);
            return new AutoValue_V20180212165000_AddDefaultCollectors_MigrationState(merged);
        }

        @JsonIgnore
        public boolean isKnownDefaultTemplate(String collectorName, String os, @Nullable String template) {
            if (template == null) {
                return false;
            }
            CollectorChecksum collectorChecksum = MigrationState.checksum(collectorName, os, template);
            return this.knownChecksums().contains(collectorChecksum);
        }

        @JsonIgnore
        public static CollectorChecksum checksum(String name, String platform, String template) {
            byte[] bytes = template.getBytes(StandardCharsets.UTF_8);
            CRC32 crc32 = new CRC32();
            crc32.update(bytes, 0, bytes.length);
            return new CollectorChecksum(name, platform, crc32.getValue());
        }
    }

    public record CollectorChecksum(@JsonProperty(value="name") String name, @JsonProperty(value="platform") String platform, @JsonProperty(value="crc") Long crc) {
    }
}

