/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.sidecar.services;

import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import freemarker.cache.StringTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import freemarker.template.TemplateExceptionHandler;
import freemarker.template.TemplateModel;
import jakarta.inject.Inject;
import jakarta.inject.Provider;
import jakarta.inject.Singleton;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.bson.conversions.Bson;
import org.graylog.plugins.sidecar.rest.models.ConfigurationVariable;
import org.graylog.plugins.sidecar.rest.models.Sidecar;
import org.graylog.plugins.sidecar.services.ConfigurationVariableService;
import org.graylog.plugins.sidecar.template.RenderTemplateException;
import org.graylog.plugins.sidecar.template.directives.IndentTemplateDirective;
import org.graylog.plugins.sidecar.template.loader.MongoDbTemplateLoader;
import org.graylog2.bindings.providers.MongoJackObjectMapperProvider;
import org.graylog2.database.MongoConnection;
import org.graylog2.database.PaginatedDbService;
import org.graylog2.database.PaginatedList;
import org.graylog2.search.SearchQuery;
import org.mongojack.DBQuery;
import org.mongojack.DBSort;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class ConfigurationService
extends PaginatedDbService<org.graylog.plugins.sidecar.rest.models.Configuration> {
    private static final Logger LOG = LoggerFactory.getLogger(ConfigurationService.class);
    private final Configuration templateConfiguration;
    private final ConfigurationVariableService configurationVariableService;
    private static final String COLLECTION_NAME = "sidecar_configurations";
    private final Provider<Configuration> templateConfigurationProvider;

    @Inject
    public ConfigurationService(MongoConnection mongoConnection, MongoJackObjectMapperProvider mapper, ConfigurationVariableService configurationVariableService, Provider<Configuration> templateConfigurationProvider) {
        super(mongoConnection, mapper, org.graylog.plugins.sidecar.rest.models.Configuration.class, COLLECTION_NAME);
        this.templateConfigurationProvider = templateConfigurationProvider;
        this.templateConfiguration = this.createTemplateConfiguration(new MongoDbTemplateLoader(this.db));
        this.configurationVariableService = configurationVariableService;
        this.db.createIndex((DBObject)new BasicDBObject("id", (Object)1));
        this.db.createIndex((DBObject)new BasicDBObject("collector_id", (Object)1));
        this.db.createIndex((DBObject)new BasicDBObject("tags", (Object)1));
    }

    private Configuration createTemplateConfiguration(TemplateLoader templateLoader) {
        Configuration configuration = (Configuration)this.templateConfigurationProvider.get();
        configuration.setTemplateLoader(templateLoader);
        configuration.setSharedVariable("indent", (TemplateModel)new IndentTemplateDirective());
        configuration.setDefaultEncoding("UTF-8");
        configuration.setTemplateExceptionHandler(TemplateExceptionHandler.RETHROW_HANDLER);
        configuration.setLogTemplateExceptions(false);
        return configuration;
    }

    public org.graylog.plugins.sidecar.rest.models.Configuration find(String id) {
        return (org.graylog.plugins.sidecar.rest.models.Configuration)this.db.findOne((Bson)DBQuery.is((String)"_id", (Object)id));
    }

    public org.graylog.plugins.sidecar.rest.models.Configuration findByName(String name) {
        return (org.graylog.plugins.sidecar.rest.models.Configuration)this.db.findOne((Bson)DBQuery.is((String)"name", (Object)name));
    }

    public long count() {
        return this.db.count();
    }

    public List<org.graylog.plugins.sidecar.rest.models.Configuration> all() {
        try (Stream collectorConfigurationStream = this.streamAll();){
            List<org.graylog.plugins.sidecar.rest.models.Configuration> list = collectorConfigurationStream.collect(Collectors.toList());
            return list;
        }
    }

    public PaginatedList<org.graylog.plugins.sidecar.rest.models.Configuration> findPaginated(SearchQuery searchQuery, int page, int perPage, String sortField, String order) {
        DBQuery.Query dbQuery = searchQuery.toDBQuery();
        DBSort.SortBuilder sortBuilder = this.getSortBuilder(order, sortField);
        return this.findPaginatedWithQueryAndSort((Bson)dbQuery, (Bson)sortBuilder, page, perPage);
    }

    public List<org.graylog.plugins.sidecar.rest.models.Configuration> findByQuery(DBQuery.Query query) {
        try (Stream collectorConfigurationStream = this.streamQuery((Bson)query);){
            List<org.graylog.plugins.sidecar.rest.models.Configuration> list = collectorConfigurationStream.collect(Collectors.toList());
            return list;
        }
    }

    public List<org.graylog.plugins.sidecar.rest.models.Configuration> findByConfigurationVariable(ConfigurationVariable configurationVariable) {
        DBQuery.Query query = DBQuery.regex((String)"template", (Pattern)Pattern.compile(Pattern.quote(configurationVariable.fullName())));
        return this.findByQuery(query);
    }

    public List<org.graylog.plugins.sidecar.rest.models.Configuration> findByTags(Set<String> tags) {
        return this.findByQuery(DBQuery.in((String)"tags", tags));
    }

    public void replaceVariableNames(String oldName, String newName) {
        DBQuery.Query query = DBQuery.regex((String)"template", (Pattern)Pattern.compile(Pattern.quote(oldName)));
        List<org.graylog.plugins.sidecar.rest.models.Configuration> configurations = this.findByQuery(query);
        for (org.graylog.plugins.sidecar.rest.models.Configuration config : configurations) {
            String newTemplate = config.template().replace(oldName, newName);
            this.db.findAndModify((Bson)DBQuery.is((String)"_id", (Object)config.id()), (Bson)new BasicDBObject(), (Bson)new BasicDBObject(), false, config.toBuilder().template(newTemplate).build(), true, true);
        }
    }

    @Override
    public org.graylog.plugins.sidecar.rest.models.Configuration save(org.graylog.plugins.sidecar.rest.models.Configuration configuration) {
        return this.db.findAndModify((Bson)DBQuery.is((String)"_id", (Object)configuration.id()), (Bson)new BasicDBObject(), (Bson)new BasicDBObject(), false, configuration, true, true);
    }

    public org.graylog.plugins.sidecar.rest.models.Configuration copyConfiguration(String id, String name) {
        org.graylog.plugins.sidecar.rest.models.Configuration configuration = this.find(id);
        return org.graylog.plugins.sidecar.rest.models.Configuration.createWithoutId(configuration.collectorId(), name, configuration.color(), configuration.template(), Set.of());
    }

    public org.graylog.plugins.sidecar.rest.models.Configuration fromRequest(org.graylog.plugins.sidecar.rest.models.Configuration request) {
        return org.graylog.plugins.sidecar.rest.models.Configuration.createWithoutId(request.collectorId(), request.name(), request.color(), request.template(), request.tags());
    }

    public org.graylog.plugins.sidecar.rest.models.Configuration fromRequest(String id, org.graylog.plugins.sidecar.rest.models.Configuration request) {
        return org.graylog.plugins.sidecar.rest.models.Configuration.create(id, request.collectorId(), request.name(), request.color(), request.template(), request.tags());
    }

    public org.graylog.plugins.sidecar.rest.models.Configuration renderConfigurationForCollector(Sidecar sidecar, org.graylog.plugins.sidecar.rest.models.Configuration configuration) throws RenderTemplateException {
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("nodeId", sidecar.nodeId());
        context.put("nodeName", sidecar.nodeName());
        context.put("sidecarVersion", sidecar.sidecarVersion());
        context.put("operatingSystem", sidecar.nodeDetails().operatingSystem());
        if (sidecar.nodeDetails().collectorConfigurationDirectory() != null) {
            String pathDelim = sidecar.nodeDetails().operatingSystem().equalsIgnoreCase("windows") ? "\\" : "/";
            context.put("spoolDir", sidecar.nodeDetails().collectorConfigurationDirectory() + pathDelim + configuration.id());
        }
        context.put("tags", sidecar.nodeDetails().tags().stream().collect(Collectors.toMap(t -> t, t -> true)));
        return org.graylog.plugins.sidecar.rest.models.Configuration.create(configuration.id(), configuration.collectorId(), configuration.name(), configuration.color(), this.renderTemplate(this.templateConfiguration, configuration.id(), context), configuration.tags());
    }

    public String renderPreview(String template) throws RenderTemplateException {
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("nodeId", "<node id>");
        context.put("nodeName", "<node name>");
        context.put("sidecarVersion", "<version>");
        context.put("operatingSystem", "<operating system>");
        context.put("spoolDir", "<sidecar spool directory>");
        context.put("tags", Map.of());
        String previewName = UUID.randomUUID().toString();
        StringTemplateLoader stringTemplateLoader = new StringTemplateLoader();
        stringTemplateLoader.putTemplate(previewName, template);
        return this.renderTemplate(this.createTemplateConfiguration((TemplateLoader)stringTemplateLoader), previewName, context);
    }

    private String renderTemplate(Configuration config, String templateName, Map<String, Object> sidecarContext) throws RenderTemplateException {
        StringWriter writer = new StringWriter();
        HashMap<String, Map<String, Object>> context = new HashMap<String, Map<String, Object>>();
        context.put("sidecar", sidecarContext);
        Map<String, Object> userContext = this.configurationVariableService.all().stream().collect(Collectors.toMap(ConfigurationVariable::name, ConfigurationVariable::content));
        context.put("user", userContext);
        try {
            Template compiledTemplate = config.getTemplate(templateName);
            compiledTemplate.process(context, (Writer)writer);
        }
        catch (TemplateException e) {
            LOG.error("Failed to render template: " + e.getMessageWithoutStackTop());
            throw new RenderTemplateException(e.getFTLInstructionStack(), e);
        }
        catch (IOException e) {
            LOG.error("Failed to render template: ", (Throwable)e);
            throw new RenderTemplateException(e.getMessage(), e);
        }
        String template = ((Object)writer).toString();
        return template.endsWith("\n") ? template : template + "\n";
    }
}

