/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.search.engine;

import com.google.common.util.concurrent.Uninterruptibles;
import io.opentelemetry.instrumentation.annotations.WithSpan;
import jakarta.inject.Inject;
import jakarta.ws.rs.InternalServerErrorException;
import jakarta.ws.rs.NotFoundException;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.graylog.plugins.views.search.ExplainResults;
import org.graylog.plugins.views.search.Search;
import org.graylog.plugins.views.search.SearchDomain;
import org.graylog.plugins.views.search.SearchJob;
import org.graylog.plugins.views.search.db.SearchJobService;
import org.graylog.plugins.views.search.engine.QueryEngine;
import org.graylog.plugins.views.search.engine.normalization.SearchNormalization;
import org.graylog.plugins.views.search.engine.validation.SearchValidation;
import org.graylog.plugins.views.search.errors.SearchError;
import org.graylog.plugins.views.search.permissions.SearchUser;
import org.graylog.plugins.views.search.rest.ExecutionState;
import org.joda.time.DateTimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SearchExecutor {
    private static final Logger LOG = LoggerFactory.getLogger(SearchExecutor.class);
    private static final DateTimeZone DEFAULT_TIMEZONE = DateTimeZone.UTC;
    private final SearchDomain searchDomain;
    private final SearchJobService searchJobService;
    private final QueryEngine queryEngine;
    private final SearchValidation searchValidation;
    private final SearchNormalization searchNormalization;

    @Inject
    public SearchExecutor(SearchDomain searchDomain, SearchJobService searchJobService, QueryEngine queryEngine, SearchValidation searchValidation, SearchNormalization searchNormalization) {
        this.searchDomain = searchDomain;
        this.searchJobService = searchJobService;
        this.queryEngine = queryEngine;
        this.searchValidation = searchValidation;
        this.searchNormalization = searchNormalization;
    }

    public SearchJob execute(String searchId, SearchUser searchUser, ExecutionState executionState) {
        return this.searchDomain.getForUser(searchId, searchUser).map(s -> this.execute((Search)s, searchUser, executionState)).orElseThrow(() -> new NotFoundException("No search found with id <" + searchId + ">."));
    }

    @WithSpan
    public SearchJob execute(Search search, SearchUser searchUser, ExecutionState executionState) {
        Search preValidationSearch = this.searchNormalization.preValidation(search, searchUser, executionState);
        Set<SearchError> validationErrors = this.searchValidation.validate(preValidationSearch, searchUser);
        if (this.hasFatalError(validationErrors)) {
            return this.searchJobWithFatalError(this.searchJobService.create(preValidationSearch, searchUser.username()), validationErrors);
        }
        Search normalizedSearch = this.searchNormalization.postValidation(preValidationSearch, searchUser, executionState);
        SearchJob searchJob = this.queryEngine.execute(this.searchJobService.create(normalizedSearch, searchUser.username()), validationErrors, searchUser.timeZone().orElse(DEFAULT_TIMEZONE));
        validationErrors.forEach(searchJob::addError);
        try {
            Uninterruptibles.getUninterruptibly(searchJob.getResultFuture(), (long)60000L, (TimeUnit)TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            LOG.error("Error executing search job <{}>", (Object)searchJob.getId(), (Object)e);
            throw new InternalServerErrorException("Error executing search job: " + e.getMessage(), (Throwable)e);
        }
        catch (TimeoutException e) {
            throw new InternalServerErrorException("Timeout while executing search job");
        }
        catch (Exception e) {
            LOG.error("Other error", (Throwable)e);
            throw e;
        }
        return searchJob;
    }

    public ExplainResults explain(String searchId, SearchUser searchUser, ExecutionState executionState) {
        return this.searchDomain.getForUser(searchId, searchUser).map(s -> this.explain((Search)s, searchUser, executionState)).orElseThrow(() -> new NotFoundException("No search found with id <" + searchId + ">."));
    }

    public ExplainResults explain(Search search, SearchUser searchUser, ExecutionState executionState) {
        Search preValidationSearch = this.searchNormalization.preValidation(search, searchUser, executionState);
        Set<SearchError> validationErrors = this.searchValidation.validate(preValidationSearch, searchUser);
        Search normalizedSearch = this.searchNormalization.postValidation(preValidationSearch, searchUser, executionState);
        return this.queryEngine.explain(this.searchJobService.create(normalizedSearch, searchUser.username()), validationErrors, searchUser.timeZone().orElse(DEFAULT_TIMEZONE));
    }

    private SearchJob searchJobWithFatalError(SearchJob searchJob, Set<SearchError> validationErrors) {
        validationErrors.forEach(searchJob::addError);
        return searchJob;
    }

    private boolean hasFatalError(Set<SearchError> validationErrors) {
        return validationErrors.stream().anyMatch(SearchError::fatal);
    }
}

