/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.search.engine.monitoring.data.histogram.creation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.graylog.plugins.views.search.engine.monitoring.data.histogram.Histogram;
import org.graylog.plugins.views.search.engine.monitoring.data.histogram.MultiValueBin;
import org.graylog.plugins.views.search.engine.monitoring.data.histogram.NamedBinDefinition;
import org.graylog.plugins.views.search.engine.monitoring.data.histogram.creation.BinChooser;
import org.graylog.plugins.views.search.engine.monitoring.data.histogram.creation.ValueComputation;

public class MultiValueSingleInputHistogramCreation<T, S> {
    static final String OUTSIDE_AVAILABLE_BINS_BIN_NAME = "Higher";
    private final BinChooser<T, S> binChooser;
    private final List<T> availableBins;
    private final Map<String, ValueComputation<S, Long>> valueFunctions;
    private final List<String> schema = new ArrayList<String>(4);

    public MultiValueSingleInputHistogramCreation(Collection<T> availableBins, BinChooser<T, S> binChooser, Map<String, ValueComputation<S, Long>> valueFunctions, String inputDescription) {
        this.availableBins = new ArrayList<T>(availableBins);
        this.binChooser = binChooser;
        this.binChooser.getBinComparator().ifPresent(this.availableBins::sort);
        this.valueFunctions = valueFunctions;
        this.schema.add(inputDescription);
        this.schema.addAll(valueFunctions.keySet());
    }

    public Histogram create(Collection<S> executionStats) {
        int numTotalStats = executionStats.size();
        LinkedHashMap separatedInBins = new LinkedHashMap();
        this.availableBins.forEach(p -> separatedInBins.put(p, new LinkedList()));
        LinkedList overBiggestBin = new LinkedList();
        executionStats.forEach(queryExecutionStats -> {
            Optional<Object> chosenBin = this.binChooser.chooseBin(this.availableBins, queryExecutionStats);
            chosenBin.ifPresentOrElse(per -> ((Collection)separatedInBins.get(per)).add(queryExecutionStats), () -> overBiggestBin.add(queryExecutionStats));
        });
        List bins = separatedInBins.entrySet().stream().map(entry -> this.entryToBin(entry.getKey().toString(), (Collection)entry.getValue(), numTotalStats)).collect(Collectors.toCollection(ArrayList::new));
        bins.add(this.entryToBin(OUTSIDE_AVAILABLE_BINS_BIN_NAME, overBiggestBin, numTotalStats));
        return new Histogram(this.schema, bins);
    }

    private MultiValueBin<NamedBinDefinition> entryToBin(String binName, Collection<S> executionStats, int numTotalStats) {
        NamedBinDefinition binDefinition = new NamedBinDefinition(binName);
        List<Number> values = this.valueFunctions.values().stream().map(func -> (Long)func.computeValue(executionStats, numTotalStats)).collect(Collectors.toList());
        return new MultiValueBin<NamedBinDefinition>(binDefinition, values);
    }
}

