/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.search.rest.remote;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.container.AsyncResponse;
import jakarta.ws.rs.container.Suspended;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.util.concurrent.ExecutorService;
import okhttp3.ResponseBody;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.graylog.plugins.views.search.permissions.SearchUser;
import org.graylog.plugins.views.search.rest.remote.RemoteSearchJobsStatusInterface;
import org.graylog2.cluster.NodeService;
import org.graylog2.plugin.rest.PluginRestResource;
import org.graylog2.rest.RemoteInterfaceProvider;
import org.graylog2.rest.RestTools;
import org.graylog2.shared.rest.resources.ProxiedResource;

@Api(value="SearchJobs", tags={"cloud"})
@Path(value="/views/searchjobs")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@RequiresAuthentication
public class SearchJobsStatusResource
extends ProxiedResource
implements PluginRestResource {
    @Inject
    public SearchJobsStatusResource(@Context HttpHeaders httpHeaders, NodeService nodeService, RemoteInterfaceProvider remoteInterfaceProvider, ExecutorService executorService) {
        super(httpHeaders, nodeService, remoteInterfaceProvider, executorService);
    }

    @GET
    @ApiOperation(value="Retrieve the status of an executed query")
    @Path(value="{nodeId}/{jobId}/status")
    @Produces(value={"application/json", "application/vnd.graylog.search.v1+json"})
    public void asyncSearchJobStatus(@ApiParam(name="jobId") @PathParam(value="jobId") String jobId, @ApiParam(name="nodeId") @PathParam(value="nodeId") String nodeId, @Context SearchUser searchUser, @Suspended AsyncResponse asyncResponse) {
        this.processAsync(asyncResponse, () -> {
            try {
                ProxiedResource.NodeResponse<ResponseBody> nodeResponse = this.requestOnNode(nodeId, r -> r.jobStatus(jobId), RemoteSearchJobsStatusInterface.class);
                return RestTools.streamResponse(nodeResponse, "application/json", null);
            }
            catch (IOException e) {
                return Response.serverError().entity((Object)e.getMessage()).build();
            }
        });
    }
}

