/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.search.validation.validators;

import com.google.common.collect.ImmutableList;
import jakarta.inject.Singleton;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.graylog.plugins.views.search.engine.QueryPosition;
import org.graylog.plugins.views.search.rest.MappedFieldTypeDTO;
import org.graylog.plugins.views.search.validation.ParsedTerm;
import org.graylog.plugins.views.search.validation.QueryValidator;
import org.graylog.plugins.views.search.validation.ValidationContext;
import org.graylog.plugins.views.search.validation.ValidationMessage;
import org.graylog.plugins.views.search.validation.ValidationStatus;
import org.graylog.plugins.views.search.validation.ValidationType;
import org.graylog.plugins.views.search.validation.validators.util.UnknownFieldsListLimiter;
import org.graylog2.plugin.Message;

@Singleton
public class UnknownFieldsValidator
implements QueryValidator {
    private final UnknownFieldsListLimiter unknownFieldsListLimiter = new UnknownFieldsListLimiter();

    @Override
    public List<ValidationMessage> validate(ValidationContext context) {
        Set<String> availableFields = context.availableFields().stream().map(MappedFieldTypeDTO::name).collect(Collectors.toSet());
        ImmutableList<ParsedTerm> terms = context.query().terms();
        return this.identifyUnknownFields(availableFields, (List<ParsedTerm>)terms).stream().map(field -> {
            ValidationMessage.Builder message = ValidationMessage.builder(ValidationStatus.WARNING, ValidationType.UNKNOWN_FIELD).relatedProperty(field.getRealFieldName()).errorMessage("Query contains unknown field: " + field.getRealFieldName());
            field.keyToken().map(QueryPosition::from).ifPresent(message::position);
            return message.build();
        }).collect(Collectors.toList());
    }

    List<ParsedTerm> identifyUnknownFields(Set<String> availableFields, List<ParsedTerm> terms) {
        Map<String, List<ParsedTerm>> groupedByField = terms.stream().filter(t -> !t.isDefaultField()).filter(term -> !Message.SEARCHABLE_ES_FIELDS.contains(term.getRealFieldName())).filter(term -> !Message.RESERVED_SETTABLE_FIELDS.contains((Object)term.getRealFieldName())).filter(term -> !availableFields.contains(term.getRealFieldName())).distinct().collect(Collectors.groupingBy(ParsedTerm::getRealFieldName));
        return this.unknownFieldsListLimiter.filterElementsContainingUsefulInformation(groupedByField);
    }
}

