/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.search.validation.validators;

import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.graylog.plugins.views.search.elasticsearch.QueryParam;
import org.graylog.plugins.views.search.engine.QueryPosition;
import org.graylog.plugins.views.search.errors.EmptyParameterError;
import org.graylog.plugins.views.search.errors.MissingEnterpriseLicenseException;
import org.graylog.plugins.views.search.errors.SearchException;
import org.graylog.plugins.views.search.errors.UnboundParameterError;
import org.graylog.plugins.views.search.validation.ValidationMessage;
import org.graylog.plugins.views.search.validation.ValidationStatus;
import org.graylog.plugins.views.search.validation.ValidationType;
import org.graylog2.shared.utilities.ExceptionUtils;

public class ValidationErrors {
    private static final Pattern regexPosition = Pattern.compile(".*at line (\\d+), column (\\d+).", 40);

    public static List<ValidationMessage> create(SearchException searchException) {
        if (searchException.error() instanceof UnboundParameterError) {
            UnboundParameterError error = (UnboundParameterError)searchException.error();
            return ValidationErrors.paramsToValidationMessages(ValidationStatus.ERROR, error.allUnknownParameters(), ValidationType.UNDECLARED_PARAMETER, param -> "Unbound required parameter used: " + param.name());
        }
        if (searchException.error() instanceof EmptyParameterError) {
            EmptyParameterError error = (EmptyParameterError)searchException.error();
            return ValidationErrors.paramsToValidationMessages(ValidationStatus.WARNING, Collections.singleton(error.getParameterUsage()), ValidationType.EMPTY_PARAMETER, param -> error.description());
        }
        return ValidationErrors.create(searchException);
    }

    public static List<ValidationMessage> create(MissingEnterpriseLicenseException licenseException) {
        return ValidationErrors.paramsToValidationMessages(ValidationStatus.ERROR, licenseException.getQueryParams(), ValidationType.MISSING_LICENSE, param -> "Search parameter used without enterprise license: " + param.name());
    }

    public static List<ValidationMessage> create(Exception exception) {
        String input = exception.toString();
        ValidationMessage.Builder errorBuilder = ValidationMessage.builder(ValidationStatus.ERROR, ValidationType.QUERY_PARSING_ERROR);
        String rootCause = ValidationErrors.getErrorMessage(exception);
        errorBuilder.errorMessage(String.format(Locale.ROOT, "Cannot parse query, cause: %s", rootCause));
        Matcher positionMatcher = regexPosition.matcher(input);
        if (positionMatcher.find()) {
            errorBuilder.position(QueryPosition.builder().beginLine(1).beginColumn(0).endLine(Integer.parseInt(positionMatcher.group(1))).endColumn(Integer.parseInt(positionMatcher.group(2))).build());
        }
        return Collections.singletonList(errorBuilder.build());
    }

    private static String getErrorMessage(Exception exception) {
        String rootCause = ExceptionUtils.getRootCauseMessage(exception);
        if (rootCause.contains("Encountered \"<EOF>\"")) {
            return "incomplete query, query ended unexpectedly";
        }
        return rootCause;
    }

    private static List<ValidationMessage> paramsToValidationMessages(ValidationStatus validationStatus, Set<QueryParam> params, ValidationType errorType, Function<QueryParam, String> messageBuilder) {
        return params.stream().flatMap(param -> {
            String errorMessage = (String)messageBuilder.apply((QueryParam)param);
            return param.positions().stream().map(pos -> ValidationMessage.builder(validationStatus, errorType).errorMessage(errorMessage).position(QueryPosition.from(pos)).relatedProperty(param.name()).build());
        }).collect(Collectors.toList());
    }
}

