/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.storage.migration.state.actions;

import com.codahale.metrics.Counter;
import com.codahale.metrics.MetricRegistry;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.ws.rs.core.MultivaluedHashMap;
import jakarta.ws.rs.core.MultivaluedMap;
import java.io.IOException;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.graylog.plugins.views.storage.migration.state.actions.CompatibilityResult;
import org.graylog.plugins.views.storage.migration.state.actions.MigrationActions;
import org.graylog.plugins.views.storage.migration.state.actions.TrafficSnapshot;
import org.graylog.plugins.views.storage.migration.state.machine.MigrationStateMachineContext;
import org.graylog.security.certutil.CaService;
import org.graylog.security.certutil.ca.exceptions.KeyStoreStorageException;
import org.graylog2.bootstrap.preflight.PreflightConfigResult;
import org.graylog2.bootstrap.preflight.PreflightConfigService;
import org.graylog2.cluster.nodes.DataNodeDto;
import org.graylog2.cluster.nodes.DataNodeStatus;
import org.graylog2.cluster.nodes.NodeService;
import org.graylog2.cluster.preflight.DataNodeProvisioningConfig;
import org.graylog2.cluster.preflight.DataNodeProvisioningService;
import org.graylog2.indexer.datanode.ProxyRequestAdapter;
import org.graylog2.indexer.datanode.RemoteReindexRequest;
import org.graylog2.indexer.datanode.RemoteReindexingMigrationAdapter;
import org.graylog2.plugin.certificates.RenewalPolicy;
import org.graylog2.plugin.cluster.ClusterConfigService;
import org.graylog2.rest.resources.datanodes.DatanodeRestApiProxy;
import org.graylog2.system.processing.control.ClusterProcessingControl;
import org.graylog2.system.processing.control.ClusterProcessingControlFactory;
import org.graylog2.system.processing.control.RemoteProcessingControlResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class MigrationActionsImpl
implements MigrationActions {
    private static final Logger LOG = LoggerFactory.getLogger(MigrationActionsImpl.class);
    private final ClusterConfigService clusterConfigService;
    private final ClusterProcessingControlFactory clusterProcessingControlFactory;
    private final NodeService<DataNodeDto> nodeService;
    private final CaService caService;
    private final PreflightConfigService preflightConfigService;
    private MigrationStateMachineContext stateMachineContext;
    private final DataNodeProvisioningService dataNodeProvisioningService;
    private final RemoteReindexingMigrationAdapter migrationService;
    private final MetricRegistry metricRegistry;
    private final DatanodeRestApiProxy datanodeProxy;
    private final ObjectMapper objectMapper;

    @Inject
    public MigrationActionsImpl(ClusterConfigService clusterConfigService, NodeService<DataNodeDto> nodeService, CaService caService, DataNodeProvisioningService dataNodeProvisioningService, RemoteReindexingMigrationAdapter migrationService, ClusterProcessingControlFactory clusterProcessingControlFactory, PreflightConfigService preflightConfigService, MetricRegistry metricRegistry, DatanodeRestApiProxy datanodeProxy, ObjectMapper objectMapper) {
        this.clusterConfigService = clusterConfigService;
        this.nodeService = nodeService;
        this.caService = caService;
        this.dataNodeProvisioningService = dataNodeProvisioningService;
        this.clusterProcessingControlFactory = clusterProcessingControlFactory;
        this.migrationService = migrationService;
        this.preflightConfigService = preflightConfigService;
        this.metricRegistry = metricRegistry;
        this.datanodeProxy = datanodeProxy;
        this.objectMapper = objectMapper;
    }

    @Override
    public void runDirectoryCompatibilityCheck() {
        List results = this.nodeService.allActive().values().stream().map(node -> {
            ProxyRequestAdapter.ProxyRequest request = new ProxyRequestAdapter.ProxyRequest("GET", "indices-directory/compatibility", null, node.getHostname(), (MultivaluedMap<String, String>)new MultivaluedHashMap());
            try {
                ProxyRequestAdapter.ProxyResponse response = this.datanodeProxy.request(request);
                return (CompatibilityResult)this.objectMapper.readValue(response.response(), CompatibilityResult.class);
            }
            catch (IOException e) {
                return new CompatibilityResult(node.getHostname(), "unknown", new CompatibilityResult.IndexerDirectoryInformation(List.of(), "unknown"), List.of(e.getMessage()));
            }
        }).collect(Collectors.toList());
        this.getStateMachineContext().addExtendedState("compatibilityCheckResult", results.stream().allMatch(r -> r.compatibilityErrors().isEmpty()));
        this.getStateMachineContext().setResponse(results);
    }

    @Override
    public boolean isOldClusterStopped() {
        return true;
    }

    @Override
    public void rollingUpgradeSelected() {
        Counter traffic = (Counter)this.metricRegistry.getMetrics().get("org.graylog2.traffic.input");
        this.getStateMachineContext().addExtendedState("traffic_snapshot", new TrafficSnapshot(traffic.getCount()));
    }

    @Override
    public boolean directoryCompatibilityCheckOk() {
        return this.getStateMachineContext().getExtendedState("compatibilityCheckResult", Boolean.class).orElse(false);
    }

    @Override
    public void reindexUpgradeSelected() {
    }

    @Override
    public void stopMessageProcessing() {
        String authToken = (String)this.stateMachineContext.getExtendedState("authToken");
        ClusterProcessingControl<RemoteProcessingControlResource> control = this.clusterProcessingControlFactory.create(authToken);
        LOG.info("Attempting to pause processing on all nodes...");
        control.pauseProcessing();
        LOG.info("Done pausing processing on all nodes.");
        LOG.info("Waiting for output buffer to drain on all nodes...");
        control.waitForEmptyBuffers();
        LOG.info("Done waiting for output buffer to drain on all nodes.");
    }

    @Override
    public void startMessageProcessing() {
        String authToken = (String)this.stateMachineContext.getExtendedState("authToken");
        ClusterProcessingControl<RemoteProcessingControlResource> control = this.clusterProcessingControlFactory.create(authToken);
        LOG.info("Resuming message processing.");
        control.resumeGraylogMessageProcessing();
    }

    @Override
    public boolean caDoesNotExist() {
        try {
            return this.caService.get() == null;
        }
        catch (KeyStoreStorageException e) {
            return true;
        }
    }

    @Override
    public boolean renewalPolicyDoesNotExist() {
        return this.clusterConfigService.get(RenewalPolicy.class) == null;
    }

    @Override
    public boolean caAndRenewalPolicyExist() {
        return !this.caDoesNotExist() && !this.renewalPolicyDoesNotExist();
    }

    @Override
    public void provisionDataNodes() {
        PreflightConfigResult preflight = this.preflightConfigService.getPreflightConfigResult();
        if (preflight == null || !preflight.equals((Object)PreflightConfigResult.PREPARED)) {
            this.preflightConfigService.setConfigResult(PreflightConfigResult.PREPARED);
        }
        Map<String, DataNodeDto> activeDataNodes = this.nodeService.allActive();
        activeDataNodes.values().stream().filter(node -> node.getDataNodeStatus() != DataNodeStatus.AVAILABLE).filter(node -> this.dataNodeProvisioningService.getPreflightConfigFor(node.getNodeId()).map(config -> config.state() != DataNodeProvisioningConfig.State.STARTUP_PREPARED).orElse(true)).forEach(node -> this.dataNodeProvisioningService.changeState(node.getNodeId(), DataNodeProvisioningConfig.State.CONFIGURED));
    }

    @Override
    public void provisionAndStartDataNodes() {
        Map<String, DataNodeDto> activeDataNodes = this.nodeService.allActive();
        activeDataNodes.values().stream().filter(node -> node.getDataNodeStatus() != DataNodeStatus.AVAILABLE).forEach(node -> this.dataNodeProvisioningService.changeState(node.getNodeId(), DataNodeProvisioningConfig.State.CONFIGURED));
    }

    @Override
    public boolean provisioningFinished() {
        return this.nodeService.allActive().values().stream().allMatch(node -> node.getDataNodeStatus() == DataNodeStatus.AVAILABLE || this.dataNodeProvisioningService.getPreflightConfigFor(node.getNodeId()).map(dn -> dn.state() == DataNodeProvisioningConfig.State.STARTUP_PREPARED).orElse(false) != false);
    }

    @Override
    public void startDataNodes() {
        Map<String, DataNodeDto> activeDataNodes = this.nodeService.allActive();
        activeDataNodes.values().forEach(node -> this.dataNodeProvisioningService.changeState(node.getNodeId(), DataNodeProvisioningConfig.State.STARTUP_TRIGGER));
    }

    @Override
    public boolean dataNodeStartupFinished() {
        PreflightConfigResult preflight;
        boolean dataNodesAvailable = this.nodeService.allActive().values().stream().allMatch(node -> node.getDataNodeStatus() == DataNodeStatus.AVAILABLE);
        if (dataNodesAvailable && ((preflight = this.preflightConfigService.getPreflightConfigResult()) == null || !preflight.equals((Object)PreflightConfigResult.FINISHED))) {
            this.preflightConfigService.setConfigResult(PreflightConfigResult.FINISHED);
        }
        return dataNodesAvailable;
    }

    @Override
    public void startRemoteReindex() {
        String allowlist = this.getStateMachineContext().getActionArgumentOpt("allowlist", String.class).orElseThrow(() -> new NullPointerException("allowlist has tp be provided"));
        URI hostname = Objects.requireNonNull(URI.create(this.getStateMachineContext().getActionArgument("hostname", String.class)), "hostname has to be provided");
        String user = this.getStateMachineContext().getActionArgumentOpt("user", String.class).orElse(null);
        String password = this.getStateMachineContext().getActionArgumentOpt("password", String.class).orElse(null);
        List<String> indices = this.getStateMachineContext().getActionArgumentOpt("indices", List.class).orElse(Collections.emptyList());
        int threadsCount = this.getStateMachineContext().getActionArgumentOpt("threads", Integer.class).orElse(4);
        String migrationID = this.migrationService.start(new RemoteReindexRequest(allowlist, hostname, user, password, indices, threadsCount));
        this.getStateMachineContext().addExtendedState("migrationID", migrationID);
    }

    @Override
    public void requestMigrationStatus() {
        this.getStateMachineContext().getExtendedState("migrationID", String.class).map(this.migrationService::status).ifPresent(status -> this.getStateMachineContext().setResponse(status));
    }

    @Override
    public void calculateTrafficEstimate() {
        Counter currentTraffic = (Counter)this.metricRegistry.getMetrics().get("org.graylog2.traffic.input");
        MigrationStateMachineContext context = this.getStateMachineContext();
        if (context.getExtendedState("estimated_traffic") == null) {
            context.getExtendedState("traffic_snapshot", TrafficSnapshot.class).ifPresent(traffic -> context.addExtendedState("estimated_traffic", traffic.calculateEstimatedTrafficPerMinute(currentTraffic.getCount())));
        }
    }

    @Override
    public void verifyRemoteIndexerConnection() {
        URI hostname = Objects.requireNonNull(URI.create(this.getStateMachineContext().getActionArgument("hostname", String.class)), "hostname has to be provided");
        String user = this.getStateMachineContext().getActionArgumentOpt("user", String.class).orElse(null);
        String password = this.getStateMachineContext().getActionArgumentOpt("password", String.class).orElse(null);
        this.getStateMachineContext().setResponse(this.migrationService.checkConnection(hostname, user, password));
    }

    @Override
    public boolean isRemoteReindexingFinished() {
        return Optional.ofNullable(this.getStateMachineContext()).flatMap(ctx -> ctx.getExtendedState("migrationID", String.class)).map(this.migrationService::status).filter(m -> m.status() == RemoteReindexingMigrationAdapter.Status.FINISHED).isPresent();
    }

    @Override
    public void setStateMachineContext(MigrationStateMachineContext context) {
        this.stateMachineContext = context;
    }

    @Override
    public MigrationStateMachineContext getStateMachineContext() {
        return this.stateMachineContext;
    }
}

