/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.storage.migration.state.machine;

import com.github.oxo42.stateless4j.StateMachine;
import jakarta.inject.Inject;
import jakarta.inject.Provider;
import jakarta.inject.Singleton;
import org.graylog.plugins.views.storage.migration.state.actions.MigrationActions;
import org.graylog.plugins.views.storage.migration.state.machine.MigrationState;
import org.graylog.plugins.views.storage.migration.state.machine.MigrationStateMachine;
import org.graylog.plugins.views.storage.migration.state.machine.MigrationStateMachineBuilder;
import org.graylog.plugins.views.storage.migration.state.machine.MigrationStateMachineImpl;
import org.graylog.plugins.views.storage.migration.state.machine.MigrationStep;
import org.graylog.plugins.views.storage.migration.state.persistence.DatanodeMigrationPersistence;

@Singleton
public class MigrationStateMachineProvider
implements Provider<MigrationStateMachine> {
    private final DatanodeMigrationPersistence persistenceService;
    private final MigrationActions migrationActions;

    @Inject
    public MigrationStateMachineProvider(DatanodeMigrationPersistence persistenceService, MigrationActions migrationActions) {
        this.persistenceService = persistenceService;
        this.migrationActions = migrationActions;
    }

    public MigrationStateMachine get() {
        StateMachine<MigrationState, MigrationStep> stateMachine = MigrationStateMachineBuilder.buildFromPersistedState(this.persistenceService, this.migrationActions);
        return new MigrationStateMachineImpl(stateMachine, this.migrationActions, this.persistenceService);
    }
}

