/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.bootstrap.preflight.web;

import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.inject.Singleton;
import java.net.URI;
import java.util.List;
import org.graylog2.Configuration;
import org.graylog2.bootstrap.preflight.PreflightConfigResult;
import org.graylog2.bootstrap.preflight.PreflightConfigService;

@Singleton
public class PreflightBoot {
    private final boolean isFreshInstallation;
    private final List<URI> hosts;
    private final PreflightConfigService preflightConfigServiceIf;
    private final Configuration configuration;

    @Inject
    public PreflightBoot(@Named(value="isFreshInstallation") boolean isFreshInstallation, @Named(value="elasticsearch_hosts") List<URI> hosts, PreflightConfigService preflightConfigServiceIf, Configuration configuration) {
        this.isFreshInstallation = isFreshInstallation;
        this.hosts = hosts;
        this.preflightConfigServiceIf = preflightConfigServiceIf;
        this.configuration = configuration;
    }

    public boolean shouldRunPreflightWeb() {
        if (this.configuration.enablePreflightWebserver()) {
            return true;
        }
        if (!this.isFreshInstallation) {
            return false;
        }
        if (!this.hosts.isEmpty()) {
            return false;
        }
        return !this.preflightFinishedOrSkipped();
    }

    private boolean preflightFinishedOrSkipped() {
        PreflightConfigResult result = this.preflightConfigServiceIf.getPreflightConfigResult();
        return result == PreflightConfigResult.FINISHED || result == PreflightConfigResult.SKIPPED;
    }
}

