/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.cluster.nodes;

import com.google.common.collect.ImmutableList;
import com.mongodb.AggregationOptions;
import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import com.mongodb.WriteResult;
import jakarta.inject.Inject;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Spliterators;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.bson.types.ObjectId;
import org.graylog2.Configuration;
import org.graylog2.cluster.Node;
import org.graylog2.cluster.NodeNotFoundException;
import org.graylog2.cluster.nodes.AbstractNode;
import org.graylog2.cluster.nodes.NodeDto;
import org.graylog2.cluster.nodes.NodeService;
import org.graylog2.database.MongoConnection;
import org.graylog2.database.PersistedServiceImpl;
import org.graylog2.plugin.system.NodeId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractNodeService<T extends AbstractNode<? extends NodeDto>, DTO extends NodeDto>
extends PersistedServiceImpl
implements NodeService<DTO> {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractNodeService.class);
    public static final String LAST_SEEN_FIELD = "$last_seen";
    private final long pingTimeout;
    private static final Map<String, Object> lastSeenFieldDefinition = Map.of("last_seen", Map.of("$type", "timestamp"));
    private static final DBObject addLastSeenFieldAsDate = new BasicDBObject("$addFields", Map.of("last_seen_date", Map.of("$cond", Map.of("if", Map.of("$isNumber", "$last_seen"), "then", Map.of("$toDate", Map.of("$toLong", "$last_seen")), "else", Map.of("$toDate", Map.of("$dateToString", Map.of("date", "$last_seen")))))));
    private final Class<T> nodeClass;

    @Inject
    public AbstractNodeService(MongoConnection mongoConnection, Configuration configuration, Class<T> nodeClass) {
        this(mongoConnection, configuration.getStaleLeaderTimeout(), nodeClass);
    }

    private AbstractNodeService(MongoConnection mongoConnection, int staleLeaderTimeout, Class<T> nodeClass) {
        super(mongoConnection);
        this.pingTimeout = staleLeaderTimeout;
        this.nodeClass = nodeClass;
    }

    @Override
    public boolean registerServer(NodeDto dto) {
        Map<String, Object> params = dto.toEntityParameters();
        Map<String, Map<String, Object>> fields = Map.of("$set", params, "$currentDate", lastSeenFieldDefinition);
        WriteResult result = this.collection(this.nodeClass).update((DBObject)new BasicDBObject("node_id", (Object)dto.getId()), (DBObject)new BasicDBObject(fields), true, false);
        return result.getN() == 1;
    }

    @Override
    public DTO byNodeId(String nodeId) throws NodeNotFoundException {
        BasicDBObject query = new BasicDBObject("node_id", (Object)nodeId);
        DBObject o = this.findOne(this.nodeClass, (DBObject)query);
        if (o == null || !o.containsField("node_id")) {
            throw new NodeNotFoundException("Unable to find node " + nodeId);
        }
        return ((AbstractNode)this.construct((ObjectId)o.get("_id"), o.toMap())).toDto();
    }

    protected T construct(ObjectId id, Map map) {
        try {
            return (T)((AbstractNode)this.nodeClass.getDeclaredConstructor(ObjectId.class, Map.class).newInstance(id, map));
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            LOG.error("Could not construct node {}", (Object)this.nodeClass.getName(), (Object)e);
            throw new RuntimeException("Could not construct node");
        }
    }

    @Override
    public DTO byNodeId(NodeId nodeId) throws NodeNotFoundException {
        return this.byNodeId(nodeId.getNodeId());
    }

    @Override
    public Map<String, DTO> byNodeIds(Collection<String> nodeIds) {
        return this.query(this.nodeClass, (DBObject)new BasicDBObject("node_id", (Object)new BasicDBObject("$in", nodeIds))).stream().map(o -> ((AbstractNode)this.construct((ObjectId)o.get("_id"), o.toMap())).toDto()).collect(Collectors.toMap(Node::getNodeId, Function.identity()));
    }

    private Stream<DBObject> aggregate(List<? extends DBObject> pipeline) {
        return this.cursorToStream((Iterator<DBObject>)this.collection(this.nodeClass).aggregate(pipeline, AggregationOptions.builder().build()));
    }

    @Override
    public Map<String, DTO> allActive() {
        return this.aggregate(this.recentHeartbeat(List.of(Map.of()))).collect(Collectors.toMap(obj -> (String)obj.get("node_id"), obj -> ((AbstractNode)this.construct((ObjectId)obj.get("_id"), obj.toMap())).toDto()));
    }

    private List<? extends DBObject> recentHeartbeat(List<? extends Map<String, Object>> additionalMatches) {
        ImmutableList match = ImmutableList.builder().add(Map.of("$expr", Map.of("$gte", List.of("$last_seen_date", Map.of("$subtract", List.of("$$NOW", Long.valueOf(this.pingTimeout))))))).addAll(additionalMatches).build();
        return List.of(addLastSeenFieldAsDate, new BasicDBObject("$match", Map.of("$and", match)), new BasicDBObject("$unset", (Object)"last_seen_date"));
    }

    @Override
    public void dropOutdated() {
        List<Object> outdatedIds = this.aggregate(List.of(addLastSeenFieldAsDate, new BasicDBObject("$match", Map.of("$expr", Map.of("$lt", List.of("$last_seen_date", Map.of("$subtract", List.of("$$NOW", Long.valueOf(this.pingTimeout))))))), new BasicDBObject("$project", Map.of("_id", "$_id")))).map(obj -> obj.get("_id")).toList();
        if (!outdatedIds.isEmpty()) {
            BasicDBObject query = new BasicDBObject("_id", Map.of("$in", outdatedIds));
            this.destroyAll(this.nodeClass, (DBObject)query);
        }
    }

    private Stream<DBObject> cursorToStream(Iterator<DBObject> cursor) {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(cursor, 16), false);
    }

    @Override
    public void markAsAlive(NodeDto dto) throws NodeNotFoundException {
        BasicDBObject query = new BasicDBObject("node_id", (Object)dto.getId());
        Map<String, Object> params = dto.toEntityParameters();
        BasicDBObject update = new BasicDBObject(Map.of("$set", params, "$currentDate", lastSeenFieldDefinition));
        WriteResult result = super.collection(this.nodeClass).update((DBObject)query, (DBObject)update);
        int updatedDocumentsCount = result.getN();
        if (updatedDocumentsCount != 1) {
            throw new NodeNotFoundException("Unable to find node " + dto.getId());
        }
    }

    @Override
    public boolean isOnlyLeader(NodeId nodeId) {
        return this.aggregate(this.recentHeartbeat(List.of(Map.of("node_id", new BasicDBObject("$ne", (Object)nodeId.getNodeId()), "is_leader", true)))).findAny().isEmpty();
    }

    @Override
    public boolean isAnyLeaderPresent() {
        return this.aggregate(this.recentHeartbeat(List.of(Map.of("is_leader", true)))).findAny().isPresent();
    }

    @Override
    public void ping(NodeDto dto) {
        try {
            this.markAsAlive(dto);
        }
        catch (NodeNotFoundException e) {
            LOG.warn("Did not find meta info of this node. Re-registering.");
            this.registerServer(dto);
        }
        try {
            this.dropOutdated();
        }
        catch (Exception e) {
            LOG.warn("Caught exception during node ping.", (Throwable)e);
        }
    }

    @Override
    public void update(NodeDto dto) {
        BasicDBObject query = new BasicDBObject("node_id", (Object)dto.getNodeId());
        BasicDBObject update = new BasicDBObject(Map.of("$set", dto.toEntityParameters()));
        super.collection(this.nodeClass).update((DBObject)query, (DBObject)update);
    }
}

