/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.indexer.datanode;

import com.mongodb.client.model.Filters;
import com.mongodb.client.model.Updates;
import jakarta.inject.Inject;
import java.util.Locale;
import java.util.Optional;
import org.bson.conversions.Bson;
import org.bson.types.ObjectId;
import org.graylog2.bindings.providers.MongoJackObjectMapperProvider;
import org.graylog2.database.MongoConnection;
import org.graylog2.database.PaginatedDbService;
import org.graylog2.indexer.datanode.MigrationConfiguration;
import org.graylog2.indexer.datanode.RemoteReindexMigrationService;
import org.graylog2.indexer.migration.LogEntry;

public class RemoteReindexMigrationServiceImpl
extends PaginatedDbService<MigrationConfiguration>
implements RemoteReindexMigrationService {
    public static final String COLLECTION_NAME = "remote_reindex_migrations";

    @Inject
    public RemoteReindexMigrationServiceImpl(MongoConnection mongoConnection, MongoJackObjectMapperProvider mapper) {
        super(mongoConnection, mapper, MigrationConfiguration.class, COLLECTION_NAME);
    }

    @Override
    public Optional<MigrationConfiguration> getMigration(String migrationId) {
        return this.get(migrationId);
    }

    @Override
    public MigrationConfiguration saveMigration(MigrationConfiguration migrationConfiguration) {
        return this.save(migrationConfiguration);
    }

    @Override
    public void assignTask(String migrationID, String indexName, String taskId) {
        Bson update;
        Bson filter = Filters.and((Bson[])new Bson[]{Filters.eq((String)"_id", (Object)new ObjectId(migrationID)), Filters.eq((String)"indices.indexName", (Object)indexName)});
        if (!this.db.update(filter, update = Updates.set((String)"indices.$.taskId", (Object)taskId)).isUpdateOfExisting()) {
            throw new IllegalStateException(String.format(Locale.ROOT, "Failed to update migration %s. Index %s doesn't exist in the migration", migrationID, indexName));
        }
    }

    @Override
    public void appendLogEntry(String migrationId, LogEntry log) {
        Bson update;
        Bson filter = Filters.eq((String)"_id", (Object)new ObjectId(migrationId));
        if (this.db.update(filter, update = Updates.push((String)"logs", (Object)log)).getN() != 1) {
            throw new IllegalStateException("Failed to append log entry:" + log);
        }
    }
}

