/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.indexer.indexset;

import jakarta.inject.Inject;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.graylog2.database.PaginatedList;
import org.graylog2.indexer.fieldtypes.IndexFieldTypesService;
import org.graylog2.indexer.indexset.IndexSetConfig;
import org.graylog2.indexer.indexset.IndexSetService;
import org.graylog2.rest.models.tools.responses.PageListResponse;
import org.graylog2.rest.resources.entities.EntityAttribute;
import org.graylog2.rest.resources.entities.EntityDefaults;
import org.graylog2.rest.resources.entities.Sorting;
import org.graylog2.rest.resources.system.indexer.responses.IndexSetFieldTypeSummary;
import org.graylog2.streams.StreamService;

public class IndexSetFieldTypeSummaryService {
    public static final String DEFAULT_SORT_FIELD = "index_set_id";
    private static final Sorting DEFAULT_SORT = Sorting.create("index_set_id", Sorting.Direction.ASC);
    private static final EntityDefaults ENTITY_DEFAULTS = EntityDefaults.builder().sort(DEFAULT_SORT).build();
    private static final List<EntityAttribute> ATTRIBUTES = List.of(EntityAttribute.builder().id("index_set_id").title("Index Set Id").hidden(true).sortable(true).build(), EntityAttribute.builder().id("index_set_title").title("Index Set Title").sortable(true).build(), EntityAttribute.builder().id("stream_titles").title("Stream Titles").sortable(false).build(), EntityAttribute.builder().id("types").title("Current Types").sortable(false).build());
    private final IndexFieldTypesService indexFieldTypesService;
    private final StreamService streamService;
    private final IndexSetService indexSetService;

    @Inject
    public IndexSetFieldTypeSummaryService(IndexFieldTypesService indexFieldTypesService, StreamService streamService, IndexSetService indexSetService) {
        this.indexFieldTypesService = indexFieldTypesService;
        this.streamService = streamService;
        this.indexSetService = indexSetService;
    }

    public PageListResponse<IndexSetFieldTypeSummary> getIndexSetFieldTypeSummary(Set<String> streamIds, String fieldName, Predicate<String> indexSetPermissionPredicate) {
        return this.getIndexSetFieldTypeSummary(streamIds, fieldName, indexSetPermissionPredicate, 1, 50, DEFAULT_SORT.id(), DEFAULT_SORT.direction());
    }

    public PageListResponse<IndexSetFieldTypeSummary> getIndexSetFieldTypeSummary(Set<String> streamIds, String fieldName, Predicate<String> indexSetPermissionPredicate, int page, int perPage, String sort, Sorting.Direction order) {
        Set<String> indexSetsIds = this.streamService.indexSetIdsByIds(streamIds);
        List pageWithIndexSetsSummaries = indexSetsIds.stream().filter(indexSetPermissionPredicate).map(this.indexSetService::get).filter(Optional::isPresent).map(Optional::get).sorted(this.getComparator(sort, order)).skip((long)(page - 1) * (long)perPage).limit(perPage).map(indexSetConfig -> {
            String indexSetId = indexSetConfig.id();
            return new IndexSetFieldTypeSummary(indexSetId, indexSetConfig.title(), this.streamService.streamTitlesForIndexSet(indexSetId), this.indexFieldTypesService.fieldTypeHistory(indexSetId, fieldName, true));
        }).collect(Collectors.toList());
        long total = indexSetsIds.stream().filter(indexSetPermissionPredicate).map(this.indexSetService::get).filter(Optional::isPresent).count();
        return PageListResponse.create("", PaginatedList.PaginationInfo.create((int)total, pageWithIndexSetsSummaries.size(), page, perPage), total, sort, order.toString().toLowerCase(Locale.ROOT), pageWithIndexSetsSummaries, ATTRIBUTES, ENTITY_DEFAULTS);
    }

    private Comparator<IndexSetConfig> getComparator(String sort, Sorting.Direction order) {
        Comparator<IndexSetConfig> comparator = Comparator.comparing(config -> {
            if (sort.equals("index_set_title")) {
                return config.title();
            }
            return config.id();
        });
        if (order == Sorting.Direction.DESC) {
            return comparator.reversed();
        }
        return comparator;
    }
}

