/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.indexer.searches;

import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.Set;
import javax.annotation.Nullable;
import org.graylog.plugins.views.search.searchfilters.model.UsedSearchFilter;
import org.graylog2.indexer.searches.ChunkCommand;
import org.graylog2.indexer.searches.Sorting;
import org.graylog2.plugin.indexer.searches.timeranges.TimeRange;

final class AutoValue_ChunkCommand
extends ChunkCommand {
    private final String query;
    private final Set<String> indices;
    private final Optional<Set<String>> streams;
    private final Optional<Sorting> sorting;
    private final Optional<String> filter;
    private final List<UsedSearchFilter> filters;
    private final Optional<TimeRange> range;
    private final OptionalInt limit;
    private final OptionalInt offset;
    private final List<String> fields;
    private final OptionalLong batchSize;
    private final Optional<ChunkCommand.SliceParams> sliceParams;
    private final boolean highlight;

    private AutoValue_ChunkCommand(String query, Set<String> indices, Optional<Set<String>> streams, Optional<Sorting> sorting, Optional<String> filter, List<UsedSearchFilter> filters, Optional<TimeRange> range, OptionalInt limit, OptionalInt offset, List<String> fields, OptionalLong batchSize, Optional<ChunkCommand.SliceParams> sliceParams, boolean highlight) {
        this.query = query;
        this.indices = indices;
        this.streams = streams;
        this.sorting = sorting;
        this.filter = filter;
        this.filters = filters;
        this.range = range;
        this.limit = limit;
        this.offset = offset;
        this.fields = fields;
        this.batchSize = batchSize;
        this.sliceParams = sliceParams;
        this.highlight = highlight;
    }

    @Override
    public String query() {
        return this.query;
    }

    @Override
    public Set<String> indices() {
        return this.indices;
    }

    @Override
    public Optional<Set<String>> streams() {
        return this.streams;
    }

    @Override
    public Optional<Sorting> sorting() {
        return this.sorting;
    }

    @Override
    public Optional<String> filter() {
        return this.filter;
    }

    @Override
    public List<UsedSearchFilter> filters() {
        return this.filters;
    }

    @Override
    public Optional<TimeRange> range() {
        return this.range;
    }

    @Override
    public OptionalInt limit() {
        return this.limit;
    }

    @Override
    public OptionalInt offset() {
        return this.offset;
    }

    @Override
    public List<String> fields() {
        return this.fields;
    }

    @Override
    public OptionalLong batchSize() {
        return this.batchSize;
    }

    @Override
    public Optional<ChunkCommand.SliceParams> sliceParams() {
        return this.sliceParams;
    }

    @Override
    public boolean highlight() {
        return this.highlight;
    }

    public String toString() {
        return "ChunkCommand{query=" + this.query + ", indices=" + this.indices + ", streams=" + this.streams + ", sorting=" + this.sorting + ", filter=" + this.filter + ", filters=" + this.filters + ", range=" + this.range + ", limit=" + this.limit + ", offset=" + this.offset + ", fields=" + this.fields + ", batchSize=" + this.batchSize + ", sliceParams=" + this.sliceParams + ", highlight=" + this.highlight + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ChunkCommand) {
            ChunkCommand that = (ChunkCommand)o;
            return this.query.equals(that.query()) && this.indices.equals(that.indices()) && this.streams.equals(that.streams()) && this.sorting.equals(that.sorting()) && this.filter.equals(that.filter()) && this.filters.equals(that.filters()) && this.range.equals(that.range()) && this.limit.equals(that.limit()) && this.offset.equals(that.offset()) && this.fields.equals(that.fields()) && this.batchSize.equals(that.batchSize()) && this.sliceParams.equals(that.sliceParams()) && this.highlight == that.highlight();
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.query.hashCode();
        h$ *= 1000003;
        h$ ^= this.indices.hashCode();
        h$ *= 1000003;
        h$ ^= this.streams.hashCode();
        h$ *= 1000003;
        h$ ^= this.sorting.hashCode();
        h$ *= 1000003;
        h$ ^= this.filter.hashCode();
        h$ *= 1000003;
        h$ ^= this.filters.hashCode();
        h$ *= 1000003;
        h$ ^= this.range.hashCode();
        h$ *= 1000003;
        h$ ^= this.limit.hashCode();
        h$ *= 1000003;
        h$ ^= this.offset.hashCode();
        h$ *= 1000003;
        h$ ^= this.fields.hashCode();
        h$ *= 1000003;
        h$ ^= this.batchSize.hashCode();
        h$ *= 1000003;
        h$ ^= this.sliceParams.hashCode();
        h$ *= 1000003;
        return h$ ^= this.highlight ? 1231 : 1237;
    }

    @Override
    public ChunkCommand.Builder toBuilder() {
        return new Builder(this);
    }

    static final class Builder
    extends ChunkCommand.Builder {
        private String query;
        private Set<String> indices;
        private Optional<Set<String>> streams = Optional.empty();
        private Optional<Sorting> sorting = Optional.empty();
        private Optional<String> filter = Optional.empty();
        private List<UsedSearchFilter> filters;
        private Optional<TimeRange> range = Optional.empty();
        private OptionalInt limit = OptionalInt.empty();
        private OptionalInt offset = OptionalInt.empty();
        private List<String> fields;
        private OptionalLong batchSize = OptionalLong.empty();
        private Optional<ChunkCommand.SliceParams> sliceParams = Optional.empty();
        private boolean highlight;
        private byte set$0;

        Builder() {
        }

        private Builder(ChunkCommand source) {
            this.query = source.query();
            this.indices = source.indices();
            this.streams = source.streams();
            this.sorting = source.sorting();
            this.filter = source.filter();
            this.filters = source.filters();
            this.range = source.range();
            this.limit = source.limit();
            this.offset = source.offset();
            this.fields = source.fields();
            this.batchSize = source.batchSize();
            this.sliceParams = source.sliceParams();
            this.highlight = source.highlight();
            this.set$0 = 1;
        }

        @Override
        public ChunkCommand.Builder query(String query) {
            if (query == null) {
                throw new NullPointerException("Null query");
            }
            this.query = query;
            return this;
        }

        @Override
        public ChunkCommand.Builder indices(Set<String> indices) {
            if (indices == null) {
                throw new NullPointerException("Null indices");
            }
            this.indices = indices;
            return this;
        }

        @Override
        public ChunkCommand.Builder streams(Set<String> streams) {
            this.streams = Optional.of(streams);
            return this;
        }

        @Override
        public ChunkCommand.Builder sorting(Sorting sorting) {
            this.sorting = Optional.of(sorting);
            return this;
        }

        @Override
        public ChunkCommand.Builder filter(@Nullable String filter) {
            this.filter = Optional.ofNullable(filter);
            return this;
        }

        @Override
        public ChunkCommand.Builder filters(List<UsedSearchFilter> filters) {
            if (filters == null) {
                throw new NullPointerException("Null filters");
            }
            this.filters = filters;
            return this;
        }

        @Override
        public ChunkCommand.Builder range(TimeRange range) {
            this.range = Optional.of(range);
            return this;
        }

        @Override
        public ChunkCommand.Builder limit(int limit) {
            this.limit = OptionalInt.of(limit);
            return this;
        }

        @Override
        public ChunkCommand.Builder offset(int offset) {
            this.offset = OptionalInt.of(offset);
            return this;
        }

        @Override
        public ChunkCommand.Builder fields(List<String> fields) {
            if (fields == null) {
                throw new NullPointerException("Null fields");
            }
            this.fields = fields;
            return this;
        }

        @Override
        public ChunkCommand.Builder batchSize(int batchSize) {
            this.batchSize = OptionalLong.of(batchSize);
            return this;
        }

        @Override
        public ChunkCommand.Builder sliceParams(@Nullable ChunkCommand.SliceParams sliceParams) {
            this.sliceParams = Optional.ofNullable(sliceParams);
            return this;
        }

        @Override
        public ChunkCommand.Builder highlight(boolean highlight) {
            this.highlight = highlight;
            this.set$0 = (byte)(this.set$0 | 1);
            return this;
        }

        @Override
        public ChunkCommand build() {
            if (this.set$0 != 1 || this.query == null || this.indices == null || this.filters == null || this.fields == null) {
                StringBuilder missing = new StringBuilder();
                if (this.query == null) {
                    missing.append(" query");
                }
                if (this.indices == null) {
                    missing.append(" indices");
                }
                if (this.filters == null) {
                    missing.append(" filters");
                }
                if (this.fields == null) {
                    missing.append(" fields");
                }
                if ((this.set$0 & 1) == 0) {
                    missing.append(" highlight");
                }
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_ChunkCommand(this.query, this.indices, this.streams, this.sorting, this.filter, this.filters, this.range, this.limit, this.offset, this.fields, this.batchSize, this.sliceParams, this.highlight);
        }
    }
}

