/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.lookup.db;

import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import org.graylog2.lookup.LookupTableConfigService;
import org.graylog2.lookup.db.DBCacheService;
import org.graylog2.lookup.db.DBDataAdapterService;
import org.graylog2.lookup.db.DBLookupTableService;
import org.graylog2.lookup.dto.CacheDto;
import org.graylog2.lookup.dto.DataAdapterDto;
import org.graylog2.lookup.dto.LookupTableDto;

@Singleton
public class DBLookupTableConfigService
implements LookupTableConfigService {
    private final DBDataAdapterService dbAdapters;
    private final DBCacheService dbCaches;
    private final DBLookupTableService dbTables;

    @Inject
    public DBLookupTableConfigService(DBDataAdapterService dbAdapters, DBCacheService dbCaches, DBLookupTableService dbTables) {
        this.dbAdapters = dbAdapters;
        this.dbCaches = dbCaches;
        this.dbTables = dbTables;
    }

    @Override
    public Optional<LookupTableDto> getTable(String id) {
        return this.dbTables.get(id);
    }

    @Override
    public Collection<LookupTableDto> loadAllTables() {
        return this.dbTables.findAll();
    }

    @Override
    public Collection<LookupTableDto> findTablesForDataAdapterIds(Set<String> ids) {
        return this.dbTables.findByDataAdapterIds(ids);
    }

    @Override
    public Collection<LookupTableDto> findTablesForCacheIds(Set<String> ids) {
        return this.dbTables.findByCacheIds(ids);
    }

    @Override
    public Collection<DataAdapterDto> loadAllDataAdapters() {
        return this.dbAdapters.findAll();
    }

    @Override
    public Collection<DataAdapterDto> findDataAdaptersForIds(Set<String> ids) {
        return this.dbAdapters.findByIds(ids);
    }

    @Override
    public Collection<CacheDto> loadAllCaches() {
        return this.dbCaches.findAll();
    }

    @Override
    public Collection<CacheDto> findCachesForIds(Set<String> ids) {
        return this.dbCaches.findByIds(ids);
    }
}

