/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.rest.models.system.sessions.responses;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.inject.Inject;
import java.util.Date;
import org.apache.shiro.session.Session;
import org.apache.shiro.subject.Subject;
import org.graylog2.rest.models.system.sessions.responses.DefaultSessionResponse;
import org.graylog2.rest.models.system.sessions.responses.SessionResponse;
import org.graylog2.rest.models.system.sessions.responses.SessionResponseFactory;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.ReadablePeriod;
import org.joda.time.Years;

public class DefaultSessionResponseFactory
implements SessionResponseFactory {
    protected final ObjectMapper objectMapper;

    @Inject
    public DefaultSessionResponseFactory(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    @Override
    public SessionResponse forSession(Session session) {
        Date validUntil = this.getValidUntil(session);
        String id = session.getId().toString();
        String userId = this.getSubjectFromSession(session).getPrincipal().toString();
        String username = String.valueOf(session.getAttribute((Object)"username"));
        return DefaultSessionResponse.create(validUntil, id, username, userId);
    }

    protected Date getValidUntil(Session session) {
        if (session.getTimeout() < 0L) {
            return new DateTime(DateTimeZone.UTC).plus((ReadablePeriod)Years.years((int)10)).toDate();
        }
        return new DateTime((Object)session.getLastAccessTime(), DateTimeZone.UTC).plus(session.getTimeout()).toDate();
    }

    protected Subject getSubjectFromSession(Session session) {
        return new Subject.Builder().sessionId(session.getId()).buildSubject();
    }

    protected JsonNode toJsonNode(Object object) {
        return this.objectMapper.valueToTree(object);
    }
}

