/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.rest.resources.datanodes;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.inject.Singleton;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.time.Duration;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.graylog2.cluster.nodes.DataNodeDto;
import org.graylog2.cluster.nodes.NodeDto;
import org.graylog2.cluster.nodes.NodeService;
import org.graylog2.indexer.datanode.ProxyRequestAdapter;
import org.graylog2.rest.resources.datanodes.DatanodeResolver;
import org.graylog2.security.IndexerJwtAuthTokenProvider;
import org.jetbrains.annotations.NotNull;

@Singleton
public class DatanodeRestApiProxy
implements ProxyRequestAdapter {
    private final IndexerJwtAuthTokenProvider authTokenProvider;
    private final NodeService<DataNodeDto> nodeService;
    private final ObjectMapper objectMapper;
    private final DatanodeResolver datanodeResolver;
    private final OkHttpClient httpClient;

    @Inject
    public DatanodeRestApiProxy(IndexerJwtAuthTokenProvider authTokenProvider, NodeService<DataNodeDto> nodeService, ObjectMapper objectMapper, DatanodeResolver datanodeResolver, OkHttpClient okHttpClient, @Named(value="proxied_requests_default_call_timeout") com.github.joschi.jadconfig.util.Duration defaultProxyTimeout) {
        this.authTokenProvider = authTokenProvider;
        this.nodeService = nodeService;
        this.objectMapper = objectMapper;
        this.datanodeResolver = datanodeResolver;
        this.httpClient = DatanodeRestApiProxy.withTimeout(okHttpClient, defaultProxyTimeout);
    }

    @NotNull
    private static OkHttpClient withTimeout(OkHttpClient okHttpClient, com.github.joschi.jadconfig.util.Duration defaultProxyTimeout) {
        Duration timeout = Duration.ofMillis(defaultProxyTimeout.toMilliseconds());
        return okHttpClient.newBuilder().connectTimeout(timeout).readTimeout(timeout).callTimeout(timeout).build();
    }

    private ProxyRequestAdapter.ProxyResponse runOnAllNodes(ProxyRequestAdapter.ProxyRequest request) {
        ProxyRequestAdapter.ProxyResponse proxyResponse;
        block9: {
            ByteArrayOutputStream baos = DatanodeRestApiProxy.copyRequestBody(request);
            try {
                Map<String, JsonNode> result = ((Stream)this.nodeService.allActive().values().stream().parallel()).collect(Collectors.toMap(NodeDto::getHostname, n -> {
                    JsonNode jsonNode;
                    ByteArrayInputStream requestBody = new ByteArrayInputStream(baos.toByteArray());
                    try {
                        ProxyRequestAdapter.ProxyResponse response = this.request(new ProxyRequestAdapter.ProxyRequest(request.method(), request.path(), requestBody, n.getHostname(), request.queryParameters()));
                        jsonNode = (JsonNode)this.objectMapper.readValue(response.response(), JsonNode.class);
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                ((InputStream)requestBody).close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                    }
                    ((InputStream)requestBody).close();
                    return jsonNode;
                }));
                ByteArrayInputStream bais = new ByteArrayInputStream(this.objectMapper.writeValueAsBytes(result));
                proxyResponse = new ProxyRequestAdapter.ProxyResponse(200, bais, "application/json");
                if (baos == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (baos != null) {
                        try {
                            baos.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (JsonProcessingException e) {
                    throw new RuntimeException("Failed to parse json responses", e);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            baos.close();
        }
        return proxyResponse;
    }

    @NotNull
    private static ByteArrayOutputStream copyRequestBody(ProxyRequestAdapter.ProxyRequest request) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (InputStream requestBody = request.body();){
            requestBody.transferTo(baos);
        }
        catch (IOException ex) {
            throw new RuntimeException("Failed to obtain request body", ex);
        }
        return baos;
    }

    @Override
    public ProxyRequestAdapter.ProxyResponse request(ProxyRequestAdapter.ProxyRequest request) throws IOException {
        if (Objects.equals("all", request.hostname())) {
            return this.runOnAllNodes(request);
        }
        String host = this.datanodeResolver.findByHostname(request.hostname()).map(DataNodeDto::getRestApiAddress).map(url -> StringUtils.removeEnd((String)url, (String)"/")).orElseThrow(() -> new IllegalStateException("No datanode found matching name " + request.hostname()));
        HttpUrl.Builder urlBuilder = HttpUrl.parse((String)host).newBuilder().addPathSegments(StringUtils.removeStart((String)request.path(), (String)"/"));
        request.queryParameters().forEach((key, values) -> values.forEach(value -> urlBuilder.addQueryParameter(key, value)));
        Request.Builder builder = new Request.Builder().url(urlBuilder.build()).addHeader("Authorization", this.authTokenProvider.get());
        switch (request.method().toUpperCase(Locale.ROOT)) {
            case "GET": {
                builder.get();
                break;
            }
            case "DELETE": {
                builder.delete();
                break;
            }
            case "POST": {
                builder.post(DatanodeRestApiProxy.getBody(request));
                break;
            }
            case "PUT": {
                builder.put(DatanodeRestApiProxy.getBody(request));
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported method " + request.method());
            }
        }
        Response response = this.httpClient.newCall(builder.build()).execute();
        return new ProxyRequestAdapter.ProxyResponse(response.code(), response.body().byteStream(), this.getContentType(response));
    }

    private String getContentType(Response response) {
        return response.header("Content-Type");
    }

    @NotNull
    private static RequestBody getBody(ProxyRequestAdapter.ProxyRequest request) throws IOException {
        return RequestBody.create((byte[])IOUtils.toByteArray((InputStream)request.body()), (MediaType)MediaType.parse((String)"application/json"));
    }
}

