/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.rest.resources.system;

import com.codahale.metrics.annotation.Timed;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Ordering;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import jakarta.inject.Inject;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import java.util.Collection;
import java.util.Map;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.apache.shiro.authz.annotation.RequiresGuest;
import org.graylog2.rest.models.system.responses.ReaderPermissionResponse;
import org.graylog2.shared.rest.resources.RestResource;
import org.graylog2.shared.security.Permissions;

@RequiresAuthentication
@Api(value="System/Permissions", description="Retrieval of system permissions.", tags={"cloud"})
@Path(value="/system/permissions")
@Produces(value={"application/json"})
public class PermissionsResource
extends RestResource {
    private final Permissions permissions;

    @Inject
    public PermissionsResource(Permissions permissions) {
        this.permissions = permissions;
    }

    @GET
    @Timed
    @RequiresGuest
    @ApiOperation(value="Get all available user permissions.")
    public Map<String, Map<String, Collection<String>>> permissions() {
        return ImmutableMap.of((Object)"permissions", this.permissions.allPermissionsMap());
    }

    @GET
    @Timed
    @RequiresGuest
    @ApiOperation(value="Get the initial permissions assigned to a reader account")
    @Path(value="reader/{username}")
    @Produces(value={"application/json"})
    public ReaderPermissionResponse readerPermissions(@ApiParam(name="username", required=true) @PathParam(value="username") String username) {
        return ReaderPermissionResponse.create(Ordering.natural().sortedCopy(this.permissions.userSelfEditPermissions(username)));
    }
}

