/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.system.activities;

import com.google.common.collect.Maps;
import jakarta.inject.Inject;
import java.util.HashMap;
import org.graylog2.plugin.ServerStatus;
import org.graylog2.plugin.Tools;
import org.graylog2.plugin.database.ValidationException;
import org.graylog2.shared.system.activities.Activity;
import org.graylog2.shared.system.activities.ActivityWriter;
import org.graylog2.system.activities.SystemMessage;
import org.graylog2.system.activities.SystemMessageService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SystemMessageActivityWriter
implements ActivityWriter {
    private static final Logger LOG = LoggerFactory.getLogger(SystemMessageActivityWriter.class);
    private final SystemMessageService systemMessageService;
    private final ServerStatus serverStatus;

    @Inject
    public SystemMessageActivityWriter(SystemMessageService systemMessageService, ServerStatus serverStatus) {
        this.systemMessageService = systemMessageService;
        this.serverStatus = serverStatus;
    }

    @Override
    public void write(Activity activity) {
        try {
            HashMap entry = Maps.newHashMap();
            entry.put("timestamp", Tools.nowUTC());
            entry.put("content", activity.getMessage());
            entry.put("caller", activity.getCaller().getCanonicalName());
            entry.put("node_id", this.serverStatus.getNodeId().toString());
            SystemMessage sm = this.systemMessageService.create(entry);
            this.systemMessageService.save(sm);
        }
        catch (ValidationException e) {
            LOG.error("Could not write activity.", (Throwable)e);
        }
    }
}

