/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.events.processor;

import com.google.common.collect.ImmutableList;
import jakarta.inject.Inject;
import jakarta.validation.constraints.NotNull;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.bson.conversions.Bson;
import org.bson.types.ObjectId;
import org.graylog.events.processor.DBEventProcessorStateService;
import org.graylog.events.processor.EventDefinition;
import org.graylog.events.processor.EventDefinitionDto;
import org.graylog.events.processor.EventProcessorConfig;
import org.graylog.events.processor.SearchFilterableConfig;
import org.graylog.plugins.views.search.searchfilters.db.SearchFiltersReFetcher;
import org.graylog.plugins.views.search.searchfilters.model.UsedSearchFilter;
import org.graylog.security.entities.EntityOwnershipService;
import org.graylog2.bindings.providers.MongoJackObjectMapperProvider;
import org.graylog2.database.MongoConnection;
import org.graylog2.database.PaginatedList;
import org.graylog2.database.entities.EntityScopeService;
import org.graylog2.database.entities.ScopedDbService;
import org.graylog2.plugin.database.users.User;
import org.graylog2.search.SearchQuery;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.mongojack.DBQuery;
import org.mongojack.DBSort;
import org.mongojack.DBUpdate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DBEventDefinitionService
extends ScopedDbService<EventDefinitionDto> {
    private static final Logger LOG = LoggerFactory.getLogger(DBEventDefinitionService.class);
    public static final String COLLECTION_NAME = "event_definitions";
    private final DBEventProcessorStateService stateService;
    private final EntityOwnershipService entityOwnerShipService;
    private final SearchFiltersReFetcher searchFiltersRefetcher;

    @Inject
    public DBEventDefinitionService(MongoConnection mongoConnection, MongoJackObjectMapperProvider mapper, DBEventProcessorStateService stateService, EntityOwnershipService entityOwnerShipService, EntityScopeService entityScopeService, SearchFiltersReFetcher searchFiltersRefetcher) {
        super(mongoConnection, mapper, EventDefinitionDto.class, COLLECTION_NAME, entityScopeService);
        this.stateService = stateService;
        this.entityOwnerShipService = entityOwnerShipService;
        this.searchFiltersRefetcher = searchFiltersRefetcher;
    }

    public PaginatedList<EventDefinitionDto> searchPaginated(SearchQuery query, Predicate<EventDefinitionDto> filter, String sortByField, String sortOrder, int page, int perPage) {
        DBQuery.Query dbQuery = query.toDBQuery();
        DBSort.SortBuilder sortBuilder = this.getSortBuilder(sortOrder, sortByField);
        PaginatedList<EventDefinitionDto> list = this.findPaginatedWithQueryFilterAndSort((Bson)dbQuery, filter, (Bson)sortBuilder, page, perPage);
        return new PaginatedList<EventDefinitionDto>(list.stream().map(this::getEventDefinitionWithRefetchedFilters).collect(Collectors.toList()), list.pagination().total(), page, perPage);
    }

    public EventDefinitionDto saveWithOwnership(EventDefinitionDto eventDefinitionDto, User user) {
        EventDefinitionDto dto = this.save(eventDefinitionDto);
        this.entityOwnerShipService.registerNewEventDefinition(dto.id(), user);
        return dto;
    }

    @Override
    public EventDefinitionDto save(EventDefinitionDto entity) {
        EventDefinitionDto enrichedWithUpdateDate = entity.toBuilder().updatedAt(DateTime.now((DateTimeZone)DateTimeZone.UTC)).build();
        return this.getEventDefinitionWithRefetchedFilters(super.save(enrichedWithUpdateDate));
    }

    @Override
    public Optional<EventDefinitionDto> get(String id) {
        return super.get(id).map(this::getEventDefinitionWithRefetchedFilters);
    }

    private EventDefinitionDto getEventDefinitionWithRefetchedFilters(EventDefinitionDto eventDefinition) {
        EventProcessorConfig config = eventDefinition.config();
        if (this.searchFiltersRefetcher.turnedOn() && config instanceof SearchFilterableConfig) {
            List<UsedSearchFilter> filters = ((SearchFilterableConfig)((Object)config)).filters();
            EventProcessorConfig updatedConfig = config.updateFilters(this.searchFiltersRefetcher.reFetch(filters));
            if (updatedConfig == null) {
                return eventDefinition;
            }
            return eventDefinition.toBuilder().config(updatedConfig).build();
        }
        return eventDefinition;
    }

    public void updateMatchedAt(String id, DateTime timeStamp) {
        this.db.updateById(new ObjectId(id), (Bson)new DBUpdate.Builder().set("matched_at", (Object)timeStamp));
    }

    public void updateState(String id, EventDefinition.State state) {
        this.db.updateById(new ObjectId(id), (Bson)new DBUpdate.Builder().set("state", (Object)state));
    }

    public int deleteUnregister(String id) {
        EventDefinitionDto dto = this.get(id).orElseThrow(() -> new IllegalArgumentException("Event Definition not found."));
        this.ensureDeletability(dto);
        this.ensureMutability(dto);
        return this.doDeleteUnregister(id, () -> super.delete(id));
    }

    public int deleteUnregisterImmutable(String id) {
        return this.doDeleteUnregister(id, () -> super.forceDelete(id));
    }

    private int doDeleteUnregister(String id, Supplier<Integer> deleteSupplier) {
        try {
            this.stateService.deleteByEventDefinitionId(id);
        }
        catch (Exception e) {
            LOG.error("Couldn't delete event processor state for <{}>", (Object)id, (Object)e);
        }
        this.entityOwnerShipService.unregisterEventDefinition(id);
        return deleteSupplier.get();
    }

    public List<EventDefinitionDto> getByNotificationId(String notificationId) {
        String field = String.format(Locale.US, "%s.%s", "notifications", "notification_id");
        return ImmutableList.copyOf(this.db.find((Bson)DBQuery.is((String)field, (Object)notificationId)).iterator());
    }

    public List<EventDefinitionDto> getSystemEventDefinitions() {
        return ImmutableList.copyOf(this.db.find((Bson)DBQuery.is((String)"_scope", (Object)"SYSTEM_NOTIFICATION_EVENT")).iterator());
    }

    @NotNull
    public List<EventDefinitionDto> getByArrayValue(String arrayField, String field, String value) {
        return ImmutableList.copyOf(this.db.find((Bson)DBQuery.elemMatch((String)arrayField, (DBQuery.Query)DBQuery.is((String)field, (Object)value))).iterator());
    }
}

