/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.events.rest;

import com.google.common.base.MoreObjects;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import java.util.Optional;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.graylog.events.search.EventsSearchFilter;
import org.graylog.events.search.EventsSearchParameters;
import org.graylog.events.search.EventsSearchResult;
import org.graylog.events.search.EventsSearchService;
import org.graylog2.audit.jersey.NoAuditEvent;
import org.graylog2.plugin.indexer.searches.timeranges.RelativeRange;
import org.graylog2.plugin.rest.PluginRestResource;
import org.graylog2.shared.rest.resources.RestResource;

@Api(value="Events", description="Events overview and search", tags={"cloud"})
@Path(value="/events")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@RequiresAuthentication
public class EventsResource
extends RestResource
implements PluginRestResource {
    private final EventsSearchService searchService;

    @Inject
    public EventsResource(EventsSearchService searchService) {
        this.searchService = searchService;
    }

    @POST
    @Path(value="/search")
    @ApiOperation(value="Search events")
    @NoAuditEvent(value="Doesn't change any data, only searches for events")
    public EventsSearchResult search(@ApiParam(name="JSON body") EventsSearchParameters request) {
        return this.searchService.search((EventsSearchParameters)MoreObjects.firstNonNull((Object)request, (Object)EventsSearchParameters.empty()), this.getSubject());
    }

    @GET
    @Path(value="{event_id}")
    @ApiOperation(value="Get event by ID")
    public Optional<EventsSearchResult.Event> getById(@ApiParam(name="event_id") @PathParam(value="event_id") String eventId) {
        EventsSearchParameters parameters = EventsSearchParameters.builder().page(1).perPage(1).timerange(RelativeRange.allTime()).query("id:" + eventId).filter(EventsSearchFilter.empty()).sortBy("timestamp").sortDirection(EventsSearchParameters.SortDirection.DESC).build();
        EventsSearchResult result = this.searchService.search(parameters, this.getSubject());
        return result.events().stream().findFirst();
    }
}

