/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.integrations.aws;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.util.Locale;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.auth.credentials.AwsBasicCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider;
import software.amazon.awssdk.auth.credentials.StaticCredentialsProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.sts.StsClient;
import software.amazon.awssdk.services.sts.StsClientBuilder;
import software.amazon.awssdk.services.sts.auth.StsAssumeRoleCredentialsProvider;
import software.amazon.awssdk.services.sts.model.AssumeRoleRequest;
import software.amazon.awssdk.services.sts.model.GetCallerIdentityRequest;

public class AWSAuthFactory {
    private static final Logger LOG = LoggerFactory.getLogger(AWSAuthFactory.class);

    public static AwsCredentialsProvider create(boolean isCloud, @Nullable String stsRegion, @Nullable String accessKey, @Nullable String secretKey, @Nullable String assumeRoleArn) {
        AwsCredentialsProvider awsCredentials;
        AwsCredentialsProvider awsCredentialsProvider = awsCredentials = isCloud ? AWSAuthFactory.getCloudAwsCredentialsProvider(accessKey, secretKey) : AWSAuthFactory.getAwsCredentialsProvider(accessKey, secretKey);
        if (!Strings.isNullOrEmpty((String)assumeRoleArn) && !Strings.isNullOrEmpty((String)stsRegion)) {
            LOG.debug("Creating cross account assume role credentials");
            return AWSAuthFactory.buildStsCredentialsProvider(awsCredentials, stsRegion, assumeRoleArn, accessKey);
        }
        return awsCredentials;
    }

    private static AwsCredentialsProvider getAwsCredentialsProvider(String accessKey, String secretKey) {
        DefaultCredentialsProvider awsCredentials;
        if (!Strings.isNullOrEmpty((String)accessKey) && !Strings.isNullOrEmpty((String)secretKey)) {
            LOG.debug("Using explicitly provided key and secret.");
            awsCredentials = StaticCredentialsProvider.create((AwsCredentials)AwsBasicCredentials.create((String)accessKey, (String)secretKey));
        } else {
            LOG.debug("Using default authorization provider chain.");
            awsCredentials = DefaultCredentialsProvider.create();
        }
        return awsCredentials;
    }

    private static AwsCredentialsProvider getCloudAwsCredentialsProvider(String accessKey, String secretKey) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)accessKey), (Object)"Access key is required.");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)secretKey), (Object)"Secret key is required.");
        return StaticCredentialsProvider.create((AwsCredentials)AwsBasicCredentials.create((String)accessKey, (String)secretKey));
    }

    private static AwsCredentialsProvider buildStsCredentialsProvider(AwsCredentialsProvider awsCredentials, String stsRegion, String assumeRoleArn, @Nullable String accessKey) {
        StsClient stsClient = (StsClient)((StsClientBuilder)((StsClientBuilder)StsClient.builder().region(Region.of((String)stsRegion))).credentialsProvider(awsCredentials)).build();
        String roleSessionName = accessKey != null ? String.format(Locale.ROOT, "ACCESS_KEY_%s@ACCOUNT_%s", accessKey, stsClient.getCallerIdentity((GetCallerIdentityRequest)GetCallerIdentityRequest.builder().build()).account()) : String.format(Locale.ROOT, "ACCOUNT_%s", stsClient.getCallerIdentity((GetCallerIdentityRequest)GetCallerIdentityRequest.builder().build()).account());
        LOG.debug("Cross account role session name: " + roleSessionName);
        return ((StsAssumeRoleCredentialsProvider.Builder)StsAssumeRoleCredentialsProvider.builder().refreshRequest((AssumeRoleRequest)AssumeRoleRequest.builder().roleSessionName(roleSessionName).roleArn(assumeRoleArn).build()).stsClient(stsClient)).build();
    }
}

