/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.integrations.aws.service;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Maps;
import jakarta.inject.Inject;
import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.InternalServerErrorException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import org.graylog.integrations.aws.AWSMessageType;
import org.graylog.integrations.aws.AWSPolicy;
import org.graylog.integrations.aws.AWSPolicyStatement;
import org.graylog.integrations.aws.resources.requests.AWSInputCreateRequest;
import org.graylog.integrations.aws.resources.responses.AWSRegion;
import org.graylog.integrations.aws.resources.responses.AvailableService;
import org.graylog.integrations.aws.resources.responses.AvailableServiceResponse;
import org.graylog.integrations.aws.resources.responses.KinesisPermissionsResponse;
import org.graylog.integrations.aws.resources.responses.RegionsResponse;
import org.graylog2.database.NotFoundException;
import org.graylog2.inputs.Input;
import org.graylog2.inputs.InputService;
import org.graylog2.plugin.configuration.ConfigurationException;
import org.graylog2.plugin.database.users.User;
import org.graylog2.plugin.inputs.MessageInput;
import org.graylog2.plugin.system.NodeId;
import org.graylog2.rest.models.system.inputs.requests.InputCreateRequest;
import org.graylog2.shared.inputs.MessageInputFactory;
import org.graylog2.shared.inputs.NoSuchInputTypeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.regions.RegionMetadata;

public class AWSService {
    private static final Logger LOG = LoggerFactory.getLogger(AWSService.class);
    private static final String AWS_POLICY_VERSION = "2012-10-17";
    public static final String POLICY_ENCODING_ERROR = "An error occurred encoding the policy JSON";
    private final InputService inputService;
    private final MessageInputFactory messageInputFactory;
    private final NodeId nodeId;
    private final ObjectMapper objectMapper;

    @Inject
    public AWSService(InputService inputService, MessageInputFactory messageInputFactory, NodeId nodeId, ObjectMapper objectMapper) {
        this.inputService = inputService;
        this.messageInputFactory = messageInputFactory;
        this.nodeId = nodeId;
        this.objectMapper = objectMapper;
    }

    public RegionsResponse getAvailableRegions() {
        List<AWSRegion> regions = Region.regions().stream().filter(r -> !r.isGlobalRegion()).map(r -> {
            RegionMetadata regionMetadata = r.metadata();
            String label = String.format(Locale.ROOT, "%s: %s", regionMetadata.description(), regionMetadata.id());
            return AWSRegion.create(regionMetadata.id(), label);
        }).sorted(Comparator.comparing(AWSRegion::regionId)).collect(Collectors.toList());
        return RegionsResponse.create(regions, regions.size());
    }

    public static Map<String, String> buildRegionChoices() {
        HashMap regions = Maps.newHashMap();
        for (Region region : Region.regions()) {
            if (region.isGlobalRegion()) continue;
            RegionMetadata regionMetadata = RegionMetadata.of((Region)region);
            String displayValue = String.format(Locale.ROOT, "%s: %s", regionMetadata.description(), region.id());
            regions.put(region.id(), displayValue);
        }
        return regions;
    }

    public AvailableServiceResponse getAvailableServices() {
        String policy;
        AWSPolicy awsPolicy = this.buildAwsSetupPolicy();
        ArrayList<AvailableService> services = new ArrayList<AvailableService>();
        try {
            policy = this.objectMapper.writeValueAsString((Object)awsPolicy);
        }
        catch (JsonProcessingException e) {
            LOG.error(POLICY_ENCODING_ERROR, (Throwable)e);
            throw new InternalServerErrorException(POLICY_ENCODING_ERROR, (Throwable)e);
        }
        AvailableService cloudWatchService = AvailableService.create("CloudWatch", "Retrieve CloudWatch logs via Kinesis. Kinesis allows streaming of the logs in real time. AWS CloudWatch is a monitoring and management service built for developers, system operators, site reliability engineers (SRE), and IT managers.", policy, "Requires Kinesis", "https://aws.amazon.com/cloudwatch/");
        services.add(cloudWatchService);
        return AvailableServiceResponse.create(services, services.size());
    }

    public KinesisPermissionsResponse getPermissions() {
        String setupPolicyString = this.policyAsJsonString(this.buildAwsSetupPolicy());
        String autoSetupPolicyString = this.policyAsJsonString(this.buildAwsAutoSetupPolicy());
        return KinesisPermissionsResponse.create(setupPolicyString, autoSetupPolicyString);
    }

    private String policyAsJsonString(AWSPolicy setupPolicy) {
        try {
            return this.objectMapper.writeValueAsString((Object)setupPolicy);
        }
        catch (JsonProcessingException e) {
            LOG.error(POLICY_ENCODING_ERROR, (Throwable)e);
            throw new InternalServerErrorException(POLICY_ENCODING_ERROR, (Throwable)e);
        }
    }

    private AWSPolicy buildAwsSetupPolicy() {
        List<String> actions = Arrays.asList("cloudwatch:PutMetricData", "dynamodb:CreateTable", "dynamodb:DescribeTable", "dynamodb:GetItem", "dynamodb:PutItem", "dynamodb:Scan", "dynamodb:UpdateItem", "ec2:DescribeInstances", "ec2:DescribeNetworkInterfaceAttribute", "ec2:DescribeNetworkInterfaces", "elasticloadbalancing:DescribeLoadBalancerAttributes", "elasticloadbalancing:DescribeLoadBalancers", "iam:CreateRole", "iam:GetRole", "iam:PassRole", "iam:PutRolePolicy", "kinesis:CreateStream", "kinesis:DescribeStream", "kinesis:GetRecords", "kinesis:GetShardIterator", "kinesis:ListShards", "kinesis:ListStreams", "logs:DescribeLogGroups", "logs:PutSubscriptionFilter");
        AWSPolicyStatement statement = AWSPolicyStatement.create("GraylogKinesisSetup", "Allow", actions, "*");
        return AWSPolicy.create(AWS_POLICY_VERSION, Collections.singletonList(statement));
    }

    private AWSPolicy buildAwsAutoSetupPolicy() {
        List<String> actions = Arrays.asList("iam:PassRole", "logs:DescribeSubscriptionFilters", "logs:PutLogEvents", "kinesis:CreateStream", "kinesis:DescribeStreamConsumer", "kinesis:PutRecord", "kinesis:RegisterStreamConsumer");
        AWSPolicyStatement statement = AWSPolicyStatement.create("GraylogKinesisAutoSetup", "Allow", actions, "*");
        return AWSPolicy.create(AWS_POLICY_VERSION, Collections.singletonList(statement));
    }

    public Input saveInput(AWSInputCreateRequest request, User user) throws Exception {
        HashMap<String, Object> configuration = new HashMap<String, Object>();
        configuration.put("aws_message_type", request.awsMessageType());
        configuration.put("throttling_allowed", request.throttlingAllowed());
        configuration.put("aws_flow_log_prefix", request.addFlowLogPrefix());
        configuration.put("aws_region", request.region());
        configuration.put("aws_access_key", request.awsAccessKeyId());
        configuration.put("aws_secret_key", request.awsSecretAccessKey());
        configuration.put("aws_assume_role_arn", request.assumeRoleArn());
        configuration.put("cloudwatch_endpoint", request.cloudwatchEndpoint());
        configuration.put("dynamodb_endpoint", request.dynamodbEndpoint());
        configuration.put("iam_endpoint", request.iamEndpoint());
        configuration.put("kinesis_endpoint", request.kinesisEndpoint());
        AWSMessageType inputType = AWSMessageType.valueOf(request.awsMessageType());
        if (!inputType.isKinesis()) {
            throw new Exception("The specified input type is not supported.");
        }
        configuration.put("kinesis_stream_name", request.streamName());
        configuration.put("kinesis_record_batch_size", request.batchSize());
        InputCreateRequest inputCreateRequest = InputCreateRequest.create(request.name(), "org.graylog.integrations.aws.inputs.AWSInput", true, configuration, this.nodeId.getNodeId());
        try {
            MessageInput messageInput = this.messageInputFactory.create(inputCreateRequest, user.getName(), this.nodeId.getNodeId());
            messageInput.checkConfiguration();
            Input input = this.inputService.create(messageInput.asMap());
            String newInputId = this.inputService.save(input);
            LOG.debug("New AWS input created. id [{}] request [{}]", (Object)newInputId, (Object)request);
            return input;
        }
        catch (NoSuchInputTypeException e) {
            LOG.error("There is no such input type registered.", (Throwable)e);
            throw new NotFoundException("There is no such input type registered.", e);
        }
        catch (ConfigurationException e) {
            LOG.error("Missing or invalid input configuration.", (Throwable)e);
            throw new BadRequestException("Missing or invalid input configuration.", (Throwable)e);
        }
    }
}

