/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.integrations.notifications.types.microsoftteams;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.auto.value.AutoValue;
import jakarta.validation.constraints.NotBlank;
import java.net.URI;
import org.graylog.events.contentpack.entities.EventNotificationConfigEntity;
import org.graylog.events.event.EventDto;
import org.graylog.events.notifications.EventNotificationConfig;
import org.graylog.events.notifications.EventNotificationExecutionJob;
import org.graylog.integrations.notifications.types.microsoftteams.AutoValue_TeamsEventNotificationConfigV2;
import org.graylog.integrations.notifications.types.microsoftteams.TeamsEventNotificationConfigV2Entity;
import org.graylog.scheduler.JobTriggerData;
import org.graylog2.contentpacks.EntityDescriptorIds;
import org.graylog2.contentpacks.model.entities.references.ValueReference;
import org.graylog2.plugin.rest.ValidationResult;
import org.joda.time.DateTimeZone;

@JsonTypeName(value="teams-notification-v2")
@JsonDeserialize(builder=Builder.class)
@AutoValue
public abstract class TeamsEventNotificationConfigV2
implements EventNotificationConfig {
    public static final String TYPE_NAME = "teams-notification-v2";
    public static final long DEFAULT_BACKLOG_SIZE = 0L;
    private static final String WEBHOOK_URL = "https://server.region.logic.azure.com:443/workflows/xxxxxxx";
    private static final DateTimeZone DEFAULT_TIME_ZONE = DateTimeZone.UTC;
    public static final String DEFAULT_ADAPTIVE_CARD = "{\n  \"contentType\": \"application/vnd.microsoft.card.adaptive\",\n  \"content\": {\n    \"type\": \"AdaptiveCard\",\n    \"version\": \"1.6\",\n    \"body\": [\n      {\n        \"type\": \"TextBlock\",\n        \"size\": \"Large\",\n        \"weight\": \"Bolder\",\n        \"text\": \"${event_definition_title} triggered\",\n        \"style\": \"heading\",\n        \"fontType\": \"Default\"\n      },\n      {\n        \"type\": \"TextBlock\",\n        \"text\": \"${event_definition_description}\",\n        \"wrap\": true\n      }\n    ],\n    \"$schema\": \"http://adaptivecards.io/schemas/adaptive-card.json\",\n    \"rtl\": false\n  }\n}";
    static final String INVALID_WEBHOOK_ERROR_MESSAGE = "Specified Webhook URL is not a valid URL";
    static final String INVALID_BACKLOG_ERROR_MESSAGE = "Backlog size cannot be less than zero";
    static final String FIELD_WEBHOOK_URL = "webhook_url";
    static final String FIELD_ADAPTIVE_CARD = "adaptive_card";
    static final String FIELD_BACKLOG_SIZE = "backlog_size";
    static final String FIELD_TIME_ZONE = "time_zone";

    @JsonProperty(value="backlog_size")
    public abstract long backlogSize();

    @JsonProperty(value="webhook_url")
    @NotBlank
    public abstract String webhookUrl();

    @JsonProperty(value="adaptive_card")
    public abstract String adaptiveCard();

    @JsonProperty(value="time_zone")
    public abstract DateTimeZone timeZone();

    @Override
    @JsonIgnore
    public JobTriggerData toJobTriggerData(EventDto dto) {
        return EventNotificationExecutionJob.Data.builder().eventDto(dto).build();
    }

    @Override
    public EventNotificationConfigEntity toContentPackEntity(EntityDescriptorIds entityDescriptorIds) {
        return TeamsEventNotificationConfigV2Entity.builder().webhookUrl(ValueReference.of(this.webhookUrl())).adaptiveCard(ValueReference.of(this.adaptiveCard())).timeZone(ValueReference.of(this.timeZone().getID())).build();
    }

    public static Builder builder() {
        return Builder.create();
    }

    @Override
    @JsonIgnore
    public ValidationResult validate() {
        ValidationResult validation = new ValidationResult();
        try {
            new URI(this.webhookUrl());
        }
        catch (Exception ex) {
            validation.addError(FIELD_WEBHOOK_URL, INVALID_WEBHOOK_ERROR_MESSAGE);
        }
        if (this.backlogSize() < 0L) {
            validation.addError(FIELD_BACKLOG_SIZE, INVALID_BACKLOG_ERROR_MESSAGE);
        }
        return validation;
    }

    @AutoValue.Builder
    public static abstract class Builder
    implements EventNotificationConfig.Builder<Builder> {
        @JsonCreator
        public static Builder create() {
            return new AutoValue_TeamsEventNotificationConfigV2.Builder().type(TeamsEventNotificationConfigV2.TYPE_NAME).webhookUrl(TeamsEventNotificationConfigV2.WEBHOOK_URL).adaptiveCard(TeamsEventNotificationConfigV2.DEFAULT_ADAPTIVE_CARD).backlogSize(0L).timeZone(DEFAULT_TIME_ZONE);
        }

        @JsonProperty(value="backlog_size")
        public abstract Builder backlogSize(long var1);

        @JsonProperty(value="webhook_url")
        public abstract Builder webhookUrl(String var1);

        @JsonProperty(value="adaptive_card")
        public abstract Builder adaptiveCard(String var1);

        @JsonProperty(value="time_zone")
        public abstract Builder timeZone(DateTimeZone var1);

        public abstract TeamsEventNotificationConfigV2 build();
    }
}

