/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.metrics.prometheus;

import com.github.joschi.jadconfig.Parameter;
import com.github.joschi.jadconfig.guava.converters.HostAndPortConverter;
import com.github.joschi.jadconfig.util.Duration;
import com.github.joschi.jadconfig.validators.FilePathReadableValidator;
import com.github.joschi.jadconfig.validators.PositiveDurationValidator;
import com.google.common.net.HostAndPort;
import java.nio.file.Path;

public class PrometheusExporterConfiguration {
    private static final String PREFIX = "prometheus_exporter_";
    public static final String ENABLED = "prometheus_exporter_enabled";
    public static final String BIND_ADDRESS = "prometheus_exporter_bind_address";
    public static final String MAPPING_FILE_PATH_CORE = "prometheus_exporter_mapping_file_path_core";
    public static final String MAPPING_FILE_PATH_CUSTOM = "prometheus_exporter_mapping_file_path_custom";
    public static final String MAPPING_FILE_REFRESH_INTERVAL = "prometheus_exporter_mapping_file_refresh_interval";
    private static String DEFAULT_BIND_ADDRESS_HOST = "127.0.0.1";
    private static int DEFAULT_BIND_ADDRESS_PORT = 9833;
    @Parameter(value="prometheus_exporter_enabled", required=true)
    private boolean enabled = false;
    @Parameter(value="prometheus_exporter_bind_address", converter=CustomHostAndPortConverter.class)
    private HostAndPort bindAddress = HostAndPort.fromParts((String)DEFAULT_BIND_ADDRESS_HOST, (int)DEFAULT_BIND_ADDRESS_PORT);
    @Parameter(value="prometheus_exporter_mapping_file_path_core", validators={FilePathReadableValidator.class})
    private Path mappingFilePathCore;
    @Parameter(value="prometheus_exporter_mapping_file_path_custom", validators={FilePathReadableValidator.class})
    private Path mappingFilePathCustom;
    @Parameter(value="prometheus_exporter_mapping_file_refresh_interval", validators={PositiveDurationValidator.class})
    private Duration mappingFileRefreshInterval = Duration.seconds((long)60L);

    public static class CustomHostAndPortConverter
    extends HostAndPortConverter {
        public HostAndPort convertFrom(String value) {
            return super.convertFrom(value).requireBracketsForIPv6().withDefaultPort(DEFAULT_BIND_ADDRESS_PORT);
        }
    }
}

