/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.metrics.prometheus.mapping;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableMap;
import com.google.inject.assistedinject.Assisted;
import io.prometheus.client.dropwizard.samplebuilder.MapperConfig;
import jakarta.inject.Inject;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.graylog.metrics.prometheus.mapping.AutoValue_InputMetricMapping_Config;
import org.graylog.metrics.prometheus.mapping.MetricMapping;
import org.graylog2.plugin.system.NodeId;
import org.graylog2.shared.inputs.MessageInputFactory;

public class InputMetricMapping
implements MetricMapping {
    public static final String TYPE = "input_metric";
    private final MessageInputFactory messageInputFactory;
    private final NodeId nodeId;
    private final Config config;

    @Inject
    public InputMetricMapping(MessageInputFactory messageInputFactory, NodeId nodeId, @Assisted MetricMapping.Config config) {
        this.messageInputFactory = messageInputFactory;
        this.nodeId = nodeId;
        this.config = (Config)config;
    }

    public Set<MapperConfig> toMapperConfigs() {
        return this.messageInputFactory.getAvailableInputs().keySet().stream().map(type -> {
            String match = type + ".*." + this.config.inputMetricName();
            ImmutableMap labels = ImmutableMap.of((Object)"node", (Object)this.nodeId.getNodeId(), (Object)"input_id", (Object)"${0}", (Object)"input_type", (Object)type);
            return new MapperConfig(match, "gl_" + this.config.metricName(), (Map)labels);
        }).collect(Collectors.toSet());
    }

    @JsonDeserialize(builder=Builder.class)
    @AutoValue
    public static abstract class Config
    implements MetricMapping.Config {
        @JsonProperty(value="input_metric_name")
        public abstract String inputMetricName();

        public static Builder builder() {
            return Builder.create();
        }

        @AutoValue.Builder
        public static abstract class Builder
        implements MetricMapping.Config.Builder<Builder> {
            @JsonCreator
            public static Builder create() {
                return new AutoValue_InputMetricMapping_Config.Builder().type(InputMetricMapping.TYPE);
            }

            @JsonProperty(value="input_metric_name")
            public abstract Builder inputMetricName(String var1);

            public abstract Config build();
        }
    }

    public static interface Factory
    extends MetricMapping.Factory<InputMetricMapping> {
        @Override
        public InputMetricMapping create(MetricMapping.Config var1);
    }
}

