/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.pipelineprocessor.db.mongodb;

import com.google.common.collect.ImmutableSet;
import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import com.mongodb.MongoException;
import com.swrve.ratelimitedlogger.RateLimitedLog;
import jakarta.inject.Inject;
import java.util.Collection;
import java.util.Collections;
import org.bson.conversions.Bson;
import org.graylog.plugins.pipelineprocessor.db.RuleDao;
import org.graylog.plugins.pipelineprocessor.db.RuleService;
import org.graylog.plugins.pipelineprocessor.events.RulesChangedEvent;
import org.graylog.plugins.pipelineprocessor.processors.PipelineInterpreter;
import org.graylog2.bindings.providers.MongoJackObjectMapperProvider;
import org.graylog2.database.MongoConnection;
import org.graylog2.database.NotFoundException;
import org.graylog2.database.jackson.legacy.LegacyDeleteResult;
import org.graylog2.events.ClusterEventBus;
import org.mongojack.DBCursor;
import org.mongojack.DBQuery;
import org.mongojack.DBSort;
import org.mongojack.JacksonDBCollection;
import org.mongojack.WriteResult;

public class MongoDbRuleService
implements RuleService {
    private static final RateLimitedLog log = PipelineInterpreter.getRateLimitedLog(MongoDbRuleService.class);
    private static final String COLLECTION = "pipeline_processor_rules";
    private final JacksonDBCollection<RuleDao, String> dbCollection;
    private final ClusterEventBus clusterBus;

    @Inject
    public MongoDbRuleService(MongoConnection mongoConnection, MongoJackObjectMapperProvider mapper, ClusterEventBus clusterBus) {
        this.dbCollection = JacksonDBCollection.wrap(mongoConnection.getDatabase().getCollection(COLLECTION), RuleDao.class, String.class, mapper.get());
        this.clusterBus = clusterBus;
        this.dbCollection.createIndex((DBObject)DBSort.asc((String)"title"), (DBObject)new BasicDBObject("unique", (Object)true));
    }

    @Override
    public RuleDao save(RuleDao rule) {
        WriteResult<RuleDao, String> save = this.dbCollection.save(rule);
        RuleDao savedRule = save.getSavedObject();
        this.clusterBus.post(RulesChangedEvent.updatedRuleId(savedRule.id()));
        return savedRule;
    }

    @Override
    public RuleDao load(String id) throws NotFoundException {
        RuleDao rule = this.dbCollection.findOneById(id);
        if (rule == null) {
            throw new NotFoundException("No rule with id " + id);
        }
        return rule;
    }

    @Override
    public RuleDao loadByName(String name) throws NotFoundException {
        DBQuery.Query query = DBQuery.is((String)"title", (Object)name);
        RuleDao rule = this.dbCollection.findOne((Bson)query);
        if (rule == null) {
            throw new NotFoundException("No rule with name " + name);
        }
        return rule;
    }

    @Override
    public Collection<RuleDao> loadAll() {
        DBCursor<RuleDao> ruleDaos = this.dbCollection.find().sort((Bson)DBSort.asc((String)"title"));
        try {
            ImmutableSet immutableSet = ImmutableSet.copyOf(ruleDaos);
            if (ruleDaos != null) {
                ruleDaos.close();
            }
            return immutableSet;
        }
        catch (Throwable throwable) {
            try {
                if (ruleDaos != null) {
                    try {
                        ruleDaos.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (MongoException e) {
                log.error("Unable to load processing rules", (Throwable)e);
                return Collections.emptySet();
            }
        }
    }

    @Override
    public void delete(String id) {
        LegacyDeleteResult<RuleDao, String> result = this.dbCollection.removeById(id);
        if (result.getN() != 1) {
            log.error("Unable to delete rule {}", (Object)id);
        }
        this.clusterBus.post(RulesChangedEvent.deletedRuleId(id));
    }

    @Override
    public Collection<RuleDao> loadNamed(Collection<String> ruleNames) {
        DBCursor<RuleDao> ruleDaos = this.dbCollection.find((Bson)DBQuery.in((String)"title", ruleNames));
        try {
            ImmutableSet immutableSet = ImmutableSet.copyOf(ruleDaos);
            if (ruleDaos != null) {
                ruleDaos.close();
            }
            return immutableSet;
        }
        catch (Throwable throwable) {
            try {
                if (ruleDaos != null) {
                    try {
                        ruleDaos.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (MongoException e) {
                log.error("Unable to bulk load rules", (Throwable)e);
                return Collections.emptySet();
            }
        }
    }
}

