/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.pipelineprocessor.functions.encoding;

import com.google.common.collect.ImmutableList;
import org.graylog.plugins.pipelineprocessor.EvaluationContext;
import org.graylog.plugins.pipelineprocessor.ast.functions.AbstractFunction;
import org.graylog.plugins.pipelineprocessor.ast.functions.FunctionArgs;
import org.graylog.plugins.pipelineprocessor.ast.functions.FunctionDescriptor;
import org.graylog.plugins.pipelineprocessor.ast.functions.ParameterDescriptor;
import org.graylog.plugins.pipelineprocessor.rulebuilder.RuleBuilderFunctionGroup;

abstract class BaseEncodingSingleArgStringFunction
extends AbstractFunction<String> {
    private final ParameterDescriptor<String, String> valueParam = ParameterDescriptor.string("value").ruleBuilderVariable().description("The value to encode with " + this.getEncodingName()).build();
    private final ParameterDescriptor<Boolean, Boolean> omitPaddingParam = ParameterDescriptor.bool("omit_padding").optional().description("Omit any padding characters as specified by RFC 4648 section 3.2").build();

    BaseEncodingSingleArgStringFunction() {
    }

    @Override
    public String evaluate(FunctionArgs args, EvaluationContext context) {
        String value = this.valueParam.required(args, context);
        boolean omitPadding = this.omitPaddingParam.optional(args, context).orElse(false);
        return this.getEncodedValue(value, omitPadding);
    }

    protected abstract String getEncodedValue(String var1, boolean var2);

    protected abstract String getName();

    protected abstract String getEncodingName();

    protected abstract String getRuleBuilderName();

    protected abstract String getRuleBuilderTitle();

    protected String description() {
        return this.getEncodingName() + " encoding/decoding of the string";
    }

    @Override
    public FunctionDescriptor<String> descriptor() {
        return FunctionDescriptor.builder().name(this.getName()).returnType(String.class).params((ImmutableList<ParameterDescriptor>)ImmutableList.of(this.valueParam, this.omitPaddingParam)).description(this.description()).ruleBuilderEnabled().ruleBuilderName(this.getRuleBuilderName()).ruleBuilderTitle(this.getRuleBuilderTitle()).ruleBuilderFunctionGroup(RuleBuilderFunctionGroup.ENCODING).build();
    }
}

